/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.cloudevent;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.eventmesh.connector.rocketmq.cloudevent.impl.RocketMQBinaryMessageReader;
import org.apache.eventmesh.connector.rocketmq.cloudevent.impl.RocketMQHeaders;
import org.apache.eventmesh.connector.rocketmq.cloudevent.impl.RocketMQMessageWriter;
import org.apache.rocketmq.common.message.Message;

@ParametersAreNonnullByDefault
public final class RocketMQMessageFactory {
    private RocketMQMessageFactory() {
    }

    public static MessageReader createReader(Message message) throws CloudEventRWException {
        return RocketMQMessageFactory.createReader(message.getProperties(), message.getBody());
    }

    public static MessageReader createReader(Map<String, String> props, @Nullable byte[] body) throws CloudEventRWException {
        return MessageUtils.parseStructuredOrBinaryMessage(() -> null, format -> null, () -> (String)props.get(RocketMQHeaders.SPEC_VERSION), sv -> new RocketMQBinaryMessageReader((SpecVersion)sv, props, body));
    }

    public static MessageWriter<CloudEventWriter<Message>, Message> createWriter(String topic) {
        return new RocketMQMessageWriter(topic);
    }

    public static MessageWriter<CloudEventWriter<Message>, Message> createWriter(String topic, String keys) {
        return new RocketMQMessageWriter(topic, keys);
    }

    public static MessageWriter<CloudEventWriter<Message>, Message> createWriter(String topic, String keys, String tags) {
        return new RocketMQMessageWriter(topic, keys, tags);
    }
}

