/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.admin;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.admin.Admin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.connector.rocketmq.config.ClientConfiguration;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class RocketMQAdmin
implements Admin {
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    protected DefaultMQAdminExt adminExt;
    protected String nameServerAddr;
    protected String clusterName;
    private int numOfQueue = 4;
    private int queuePermission = 6;

    public RocketMQAdmin(Properties properties) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.init();
        this.nameServerAddr = clientConfiguration.namesrvAddr;
        this.clusterName = clientConfiguration.clusterName;
        String accessKey = clientConfiguration.accessKey;
        String secretKey = clientConfiguration.secretKey;
        AclClientRPCHook rpcHook = new AclClientRPCHook(new SessionCredentials(accessKey, secretKey));
        this.adminExt = new DefaultMQAdminExt((RPCHook)rpcHook);
        String groupId = UUID.randomUUID().toString();
        this.adminExt.setAdminExtGroup("admin_ext_group-" + groupId);
        this.adminExt.setNamesrvAddr(this.nameServerAddr);
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
    }

    public void init(Properties keyValue) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicProperties> getTopic() throws Exception {
        try {
            this.adminExt.start();
            ArrayList<TopicProperties> result = new ArrayList<TopicProperties>();
            Set topicList = this.adminExt.fetchAllTopicList().getTopicList();
            for (String topic : topicList) {
                long messageCount = 0L;
                TopicStatsTable topicStats = this.adminExt.examineTopicStats(topic);
                HashMap offsetTable = topicStats.getOffsetTable();
                for (TopicOffset topicOffset : offsetTable.values()) {
                    messageCount += topicOffset.getMaxOffset() - topicOffset.getMinOffset();
                }
                result.add(new TopicProperties(topic, messageCount));
            }
            result.sort(Comparator.comparing(t -> t.name));
            ArrayList<TopicProperties> arrayList = result;
            return arrayList;
        }
        finally {
            this.adminExt.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTopic(String topicName) throws Exception {
        if (StringUtils.isBlank((CharSequence)topicName)) {
            throw new Exception("Topic name can not be blank");
        }
        try {
            this.adminExt.start();
            Set brokerAddress = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)this.adminExt, (String)this.clusterName);
            for (String masterAddress : brokerAddress) {
                TopicConfig topicConfig = new TopicConfig();
                topicConfig.setTopicName(topicName);
                topicConfig.setReadQueueNums(this.numOfQueue);
                topicConfig.setWriteQueueNums(this.numOfQueue);
                topicConfig.setPerm(this.queuePermission);
                this.adminExt.createAndUpdateTopicConfig(masterAddress, topicConfig);
            }
        }
        finally {
            this.adminExt.shutdown();
        }
    }

    public void deleteTopic(String topicName) throws Exception {
        if (StringUtils.isBlank((CharSequence)topicName)) {
            throw new Exception("Topic name can not be blank.");
        }
        try {
            this.adminExt.start();
            Set brokerAddress = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)this.adminExt, (String)this.clusterName);
            this.adminExt.deleteTopicInBroker(brokerAddress, topicName);
        }
        finally {
            this.adminExt.shutdown();
        }
    }

    public List<CloudEvent> getEvent(String topicName, int offset, int length) throws Exception {
        return null;
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
    }
}

