/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.tcp;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcpConnectionHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshTcpMonitor {
    private static final Logger log = LoggerFactory.getLogger(EventMeshTcpMonitor.class);
    private final EventMeshTCPServer eventMeshTCPServer;
    private final Logger tcpLogger = LoggerFactory.getLogger((String)"tcpMonitor");
    private final Logger appLogger = LoggerFactory.getLogger((String)"appMonitor");
    private static final int period = 60000;
    private static int PRINT_THREADPOOLSTATE_INTERVAL = 1;
    public ScheduledFuture<?> monitorTpsTask;
    public ScheduledFuture<?> monitorThreadPoolTask;
    private final TcpSummaryMetrics tcpSummaryMetrics;
    private final List<MetricsRegistry> metricsRegistries;

    public EventMeshTCPServer getEventMeshTCPServer() {
        return this.eventMeshTCPServer;
    }

    public EventMeshTcpMonitor(EventMeshTCPServer eventMeshTCPServer, List<MetricsRegistry> metricsRegistries) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.tcpSummaryMetrics = new TcpSummaryMetrics();
        this.metricsRegistries = (List)Preconditions.checkNotNull(metricsRegistries);
    }

    public void init() throws Exception {
        this.metricsRegistries.forEach(MetricsRegistry::start);
        log.info("EventMeshTcpMonitor initialized......");
    }

    public void start() throws Exception {
        this.metricsRegistries.forEach(metricsRegistry -> {
            metricsRegistry.register((Metric)this.tcpSummaryMetrics);
            log.info("Register tcpMetrics to {}", (Object)metricsRegistry.getClass().getName());
        });
        int delay = 60000;
        this.monitorTpsTask = this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(() -> {
            int msgNum = this.tcpSummaryMetrics.client2eventMeshMsgNum();
            this.tcpSummaryMetrics.resetClient2EventMeshMsgNum();
            this.tcpSummaryMetrics.setClient2eventMeshTPS(1000 * msgNum / 60000);
            msgNum = this.tcpSummaryMetrics.eventMesh2clientMsgNum();
            this.tcpSummaryMetrics.resetEventMesh2ClientMsgNum();
            this.tcpSummaryMetrics.setEventMesh2clientTPS(1000 * msgNum / 60000);
            msgNum = this.tcpSummaryMetrics.eventMesh2mqMsgNum();
            this.tcpSummaryMetrics.resetEventMesh2mqMsgNum();
            this.tcpSummaryMetrics.setEventMesh2mqTPS(1000 * msgNum / 60000);
            msgNum = this.tcpSummaryMetrics.mq2eventMeshMsgNum();
            this.tcpSummaryMetrics.resetMq2eventMeshMsgNum();
            this.tcpSummaryMetrics.setMq2eventMeshTPS(1000 * msgNum / 60000);
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = this.eventMeshTCPServer.getClientSessionGroupMapping().getSessionMap();
            Iterator<Session> sessionIterator = sessionMap.values().iterator();
            HashSet topicSet = new HashSet();
            while (sessionIterator.hasNext()) {
                Session session = sessionIterator.next();
                AtomicLong deliveredMsgsCount = session.getPusher().getDeliveredMsgsCount();
                AtomicLong deliveredFailCount = session.getPusher().getDeliverFailMsgsCount();
                int unAckMsgsCount = session.getPusher().getTotalUnackMsgs();
                int sendTopics = session.getSessionContext().sendTopics.size();
                int subscribeTopics = session.getSessionContext().subscribeTopics.size();
                this.tcpLogger.info("session|deliveredFailCount={}|deliveredMsgsCount={}|unAckMsgsCount={}|sendTopics={}|subscribeTopics={}|user={}", new Object[]{deliveredFailCount.longValue(), deliveredMsgsCount.longValue(), unAckMsgsCount, sendTopics, subscribeTopics, session.getClient()});
                topicSet.addAll(session.getSessionContext().subscribeTopics.keySet());
            }
            this.tcpSummaryMetrics.setSubTopicNum(topicSet.size());
            this.tcpSummaryMetrics.setAllConnections(EventMeshTcpConnectionHandler.connections.get());
            this.printAppLogger(this.tcpSummaryMetrics);
        }, delay, 60000L, TimeUnit.MILLISECONDS);
        this.monitorThreadPoolTask = this.eventMeshTCPServer.getScheduler().scheduleAtFixedRate(() -> {
            this.eventMeshTCPServer.getEventMeshRebalanceService().printRebalanceThreadPoolState();
            this.eventMeshTCPServer.getEventMeshTcpRetryer().printRetryThreadPoolState();
            this.tcpSummaryMetrics.setRetrySize(this.eventMeshTCPServer.getEventMeshTcpRetryer().getRetrySize());
            this.appLogger.info(String.format("{\"protocol\":\"%s\",\"s\":\"%s\",\"t\":\"%s\"}", "tcp", "retryQueueSize", this.tcpSummaryMetrics.getRetrySize()));
        }, 10L, PRINT_THREADPOOLSTATE_INTERVAL, TimeUnit.SECONDS);
        log.info("EventMeshTcpMonitor started......");
    }

    private void printAppLogger(TcpSummaryMetrics tcpSummaryMetrics) {
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "client2eventMeshTPS", tcpSummaryMetrics.getClient2eventMeshTPS()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "eventMesh2mqTPS", tcpSummaryMetrics.getEventMesh2mqTPS()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "mq2eventMeshTPS", tcpSummaryMetrics.getMq2eventMeshTPS()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "eventMesh2clientTPS", tcpSummaryMetrics.getEventMesh2clientTPS()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "allTPS", tcpSummaryMetrics.getAllTPS()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "connection", tcpSummaryMetrics.getAllConnections()});
        this.appLogger.info("protocol: {}, s: {}, t: {}", new Object[]{"tcp", "subTopicNum", tcpSummaryMetrics.getSubTopicNum()});
    }

    public TcpSummaryMetrics getTcpSummaryMetrics() {
        return this.tcpSummaryMetrics;
    }

    public void shutdown() throws Exception {
        this.monitorTpsTask.cancel(true);
        this.monitorThreadPoolTask.cancel(true);
        this.metricsRegistries.forEach(MetricsRegistry::showdown);
        log.info("EventMeshTcpMonitor shutdown......");
    }
}

