/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.task;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.Subscription;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.task.AbstractTask;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeTask
extends AbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscribeTask.class);

    public SubscribeTask(Package pkg, ChannelHandlerContext ctx, long startTime, EventMeshTCPServer eventMeshTCPServer) {
        super(pkg, ctx, startTime, eventMeshTCPServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            Subscription subscriptionInfo = (Subscription)this.pkg.getBody();
            Objects.requireNonNull(subscriptionInfo, "subscriptionInfo can not be null");
            ArrayList<SubscriptionItem> subscriptionItems = new ArrayList<SubscriptionItem>();
            boolean eventMeshServerSecurityEnable = this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerSecurityEnable();
            String remoteAddr = RemotingHelper.parseChannelRemoteAddr(this.ctx.channel());
            subscriptionInfo.getTopicList().forEach(item -> {
                if (eventMeshServerSecurityEnable) {
                    Acl.doAclCheckInTcpReceive(remoteAddr, this.session.getClient(), item.getTopic(), Command.SUBSCRIBE_REQUEST.getValue());
                }
                subscriptionItems.add((SubscriptionItem)item);
            });
            Session session = this.session;
            synchronized (session) {
                this.session.subscribe(subscriptionItems);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("SubscribeTask succeed|user={}|topics={}", (Object)this.session.getClient(), subscriptionItems);
                }
            }
            msg.setHeader(new Header(Command.SUBSCRIBE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), this.pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            LOGGER.error("SubscribeTask failed|user={}|errMsg={}", (Object)this.session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.SUBSCRIBE_RESPONSE, OPStatus.FAIL.getCode().intValue(), e.toString(), this.pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(msg, this.startTime, taskExecuteTime, this.session.getContext(), this.session);
        }
    }
}

