/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.opentelemetry.api.trace.Span;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.push.AbstractHTTPPushRequest;
import org.apache.eventmesh.runtime.core.protocol.http.push.AsyncHTTPPushRequest;
import org.apache.eventmesh.runtime.core.protocol.http.push.MessageHandler;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMessageHandler
implements MessageHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(HTTPMessageHandler.class);
    private transient EventMeshConsumer eventMeshConsumer;
    private static final transient ScheduledExecutorService SCHEDULER = ThreadPoolFactory.createSingleScheduledExecutor((String)"eventMesh-pushMsgTimeout-");
    private static final Integer CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD = 10000;
    public static final transient Map<String, Set<AbstractHTTPPushRequest>> waitingRequests = Maps.newConcurrentMap();
    private transient ThreadPoolExecutor pushExecutor;

    private void checkTimeout() {
        waitingRequests.forEach((key, value) -> value.forEach(r -> {
            r.timeout();
            waitingRequests.get(r.handleMsgContext.getConsumerGroup()).remove(r);
        }));
    }

    public HTTPMessageHandler(EventMeshConsumer eventMeshConsumer) {
        this.eventMeshConsumer = eventMeshConsumer;
        this.pushExecutor = eventMeshConsumer.getEventMeshHTTPServer().pushMsgExecutor;
        waitingRequests.put(this.eventMeshConsumer.getConsumerGroupConf().getConsumerGroup(), Sets.newConcurrentHashSet());
        SCHEDULER.scheduleAtFixedRate(this::checkTimeout, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean handle(HandleMsgContext handleMsgContext) {
        if (((Set)MapUtils.getObject(waitingRequests, (Object)handleMsgContext.getConsumerGroup(), (Object)Sets.newConcurrentHashSet())).size() > CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD) {
            LOGGER.warn("waitingRequests is too many, so reject, this message will be send back to MQ, consumerGroup:{}, threshold:{}", (Object)handleMsgContext.getConsumerGroup(), (Object)CONSUMER_GROUP_WAITING_REQUEST_THRESHOLD);
            return false;
        }
        try {
            this.pushExecutor.submit(() -> {
                String protocolVersion = Objects.requireNonNull(handleMsgContext.getEvent().getSpecVersion()).toString();
                Span span = TraceUtils.prepareClientSpan(EventMeshUtil.getCloudEventExtensionMap(protocolVersion, handleMsgContext.getEvent()), "downstream-eventmesh-client-span", false);
                try {
                    new AsyncHTTPPushRequest(handleMsgContext, waitingRequests).tryHTTPRequest();
                }
                finally {
                    TraceUtils.finishSpan(span, handleMsgContext.getEvent());
                }
            });
            return true;
        }
        catch (RejectedExecutionException e) {
            LOGGER.warn("pushMsgThreadPoolQueue is full, so reject, current task size {}", (Object)handleMsgContext.getEventMeshHTTPServer().getPushMsgExecutor().getQueue().size(), (Object)e);
            return false;
        }
    }
}

