/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.consumer.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.http.retry.HttpRetryer;
import org.apache.eventmesh.runtime.core.protocol.http.retry.RetryContext;

public abstract class AbstractHTTPPushRequest
extends RetryContext {
    public EventMeshHTTPServer eventMeshHTTPServer;
    public long createTime = System.currentTimeMillis();
    public long lastPushTime = System.currentTimeMillis();
    public Map<String, List<String>> urls;
    public List<String> totalUrls;
    public volatile int startIdx;
    public EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    public HttpRetryer retryer;
    public int ttl;
    public HandleMsgContext handleMsgContext;
    private AtomicBoolean complete = new AtomicBoolean(Boolean.FALSE);

    public AbstractHTTPPushRequest(HandleMsgContext handleMsgContext) {
        this.eventMeshHTTPServer = handleMsgContext.getEventMeshHTTPServer();
        this.handleMsgContext = handleMsgContext;
        this.urls = handleMsgContext.getConsumeTopicConfig().getIdcUrls();
        this.totalUrls = Lists.newArrayList(handleMsgContext.getConsumeTopicConfig().getUrls());
        this.eventMeshHttpConfiguration = handleMsgContext.getEventMeshHTTPServer().getEventMeshHttpConfiguration();
        this.retryer = handleMsgContext.getEventMeshHTTPServer().getHttpRetryer();
        this.ttl = handleMsgContext.getTtl();
        this.startIdx = RandomUtils.nextInt((int)0, (int)this.totalUrls.size());
    }

    public void tryHTTPRequest() {
    }

    public void delayRetry(long delayTime) {
        if (this.retryTimes < 3 && delayTime > 0L) {
            ++this.retryTimes;
            this.delay(delayTime);
            this.retryer.pushRetry(this);
        } else {
            this.complete.compareAndSet(Boolean.FALSE, Boolean.TRUE);
        }
    }

    public void delayRetry() {
        if (this.retryTimes < 3) {
            ++this.retryTimes;
            this.delay(this.retryTimes * 3000);
            this.retryer.pushRetry(this);
        } else {
            this.complete.compareAndSet(Boolean.FALSE, Boolean.TRUE);
        }
    }

    public String getUrl() {
        List localIDCUrl = (List)MapUtils.getObject(this.urls, (Object)this.eventMeshHttpConfiguration.getEventMeshIDC(), null);
        if (CollectionUtils.isNotEmpty((Collection)localIDCUrl)) {
            return (String)localIDCUrl.get((this.startIdx + this.retryTimes) % localIDCUrl.size());
        }
        ArrayList<String> otherIDCUrl = new ArrayList<String>();
        for (List<String> tmp : this.urls.values()) {
            otherIDCUrl.addAll(tmp);
        }
        if (CollectionUtils.isNotEmpty(otherIDCUrl)) {
            return (String)otherIDCUrl.get((this.startIdx + this.retryTimes) % otherIDCUrl.size());
        }
        return null;
    }

    public boolean isComplete() {
        return this.complete.get();
    }

    public void complete() {
        this.complete.compareAndSet(Boolean.FALSE, Boolean.TRUE);
    }

    public void timeout() {
        if (!this.isComplete() && System.currentTimeMillis() - this.lastPushTime >= (long)this.ttl) {
            this.delayRetry();
        }
    }
}

