/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.HeartbeatResponseBody;
import org.apache.eventmesh.common.protocol.http.body.message.SendMessageResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.HeartbeatResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeatProcessor
implements HttpRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(HeartBeatProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public HeartBeatProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String localAddress = IPUtils.getLocalAddress();
        if (log.isInfoEnabled()) {
            log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        }
        HeartbeatRequestHeader heartbeatRequestHeader = (HeartbeatRequestHeader)asyncContext.getRequest().getHeader();
        HeartbeatRequestBody heartbeatRequestBody = (HeartbeatRequestBody)asyncContext.getRequest().getBody();
        HeartbeatResponseHeader heartbeatResponseHeader = HeartbeatResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster(), (String)localAddress, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        if (StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)heartbeatRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)heartbeatRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)heartbeatRequestBody.getClientType()) || StringUtils.isBlank((CharSequence)heartbeatRequestBody.getConsumerGroup()) || CollectionUtils.isEmpty((Collection)heartbeatRequestBody.getHeartbeatEntities())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        ConcurrentHashMap<String, ArrayList<Client>> tmpMap = new ConcurrentHashMap<String, ArrayList<Client>>();
        List heartbeatEntities = heartbeatRequestBody.getHeartbeatEntities();
        for (HeartbeatRequestBody.HeartbeatEntity heartbeatEntity : heartbeatEntities) {
            Client client = new Client();
            client.setEnv(heartbeatRequestHeader.getEnv());
            client.setIdc(heartbeatRequestHeader.getIdc());
            client.setSys(heartbeatRequestHeader.getSys());
            client.setIp(heartbeatRequestHeader.getIp());
            client.setPid(heartbeatRequestHeader.getPid());
            client.setConsumerGroup(heartbeatRequestBody.getConsumerGroup());
            client.setTopic(heartbeatEntity.topic);
            client.setUrl(heartbeatEntity.url);
            client.setLastUpTime(new Date());
            if (StringUtils.isBlank((CharSequence)client.getTopic())) continue;
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
                try {
                    Acl.doAclCheckInHttpHeartbeat(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), heartbeatRequestHeader.getUsername(), heartbeatRequestHeader.getPasswd(), heartbeatRequestHeader.getSys(), client.getTopic(), Integer.parseInt(heartbeatRequestHeader.getCode()));
                }
                catch (Exception e) {
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)SendMessageResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_ACL_ERR.getRetCode(), (String)e.getMessage()));
                    asyncContext.onComplete(responseEventMeshCommand);
                    if (log.isWarnEnabled()) {
                        log.warn("CLIENT HAS NO PERMISSION,HeartBeatProcessor subscribe failed", (Throwable)e);
                    }
                    return;
                }
            }
            if (StringUtils.isBlank((CharSequence)client.getUrl())) continue;
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            ArrayList<Client> clients = (ArrayList<Client>)tmpMap.get(groupTopicKey);
            if (clients == null) {
                clients = new ArrayList<Client>();
                tmpMap.put(groupTopicKey, clients);
            }
            clients.add(client);
        }
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            for (Map.Entry groupTopicClientMapping : tmpMap.entrySet()) {
                List<Client> localClientList = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().get(groupTopicClientMapping.getKey());
                if (CollectionUtils.isEmpty(localClientList)) {
                    this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().put((String)groupTopicClientMapping.getKey(), (List<Client>)groupTopicClientMapping.getValue());
                    continue;
                }
                List tmpClientList = (List)groupTopicClientMapping.getValue();
                this.supplyClientInfoList(tmpClientList, localClientList);
                this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().put((String)groupTopicClientMapping.getKey(), localClientList);
            }
        }
        long startTime = System.currentTimeMillis();
        try {
            CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

                @Override
                public void onResponse(HttpCommand httpCommand) {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("{}", (Object)httpCommand);
                        }
                        HeartBeatProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                        HeartBeatProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
            asyncContext.onComplete(responseEventMeshCommand, handler);
        }
        catch (Exception e) {
            HttpCommand err = asyncContext.getRequest().createHttpCommandResponse((Header)heartbeatResponseHeader, (Body)HeartbeatResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_HEARTBEAT_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
            asyncContext.onComplete(err);
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (log.isErrorEnabled()) {
                log.error("message|eventMesh2mq|REQ|ASYNC|heartBeatMessageCost={}ms", (Object)elapsedTime, (Object)e);
            }
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(elapsedTime);
        }
    }

    private void supplyClientInfoList(List<Client> tmpClientList, List<Client> localClientList) {
        Objects.requireNonNull(tmpClientList, "tmpClientList can not be null");
        Objects.requireNonNull(localClientList, "localClientList can not be null");
        for (Client tmpClient : tmpClientList) {
            boolean isContains = false;
            for (Client localClient : localClientList) {
                if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)tmpClient.getUrl())) continue;
                isContains = true;
                localClient.setLastUpTime(tmpClient.getLastUpTime());
                break;
            }
            if (isContains) continue;
            localClientList.add(tmpClient);
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

