/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.push;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.common.protocol.http.common.ClientRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.WebhookTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.AbstractPushRequest;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookPushRequest
extends AbstractPushRequest {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private static final Logger CMD_LOGGER = LoggerFactory.getLogger((String)"cmd");
    private final Map<String, List<String>> urls;
    private final List<String> totalUrls;
    private final int startIdx;
    private final Subscription.SubscriptionItem.SubscriptionMode subscriptionMode;

    public WebhookPushRequest(HandleMsgContext handleMsgContext, Map<String, Set<AbstractPushRequest>> waitingRequests) {
        super(handleMsgContext, waitingRequests);
        WebhookTopicConfig topicConfig = (WebhookTopicConfig)handleMsgContext.getConsumeTopicConfig();
        this.subscriptionMode = topicConfig.getSubscriptionMode();
        this.urls = topicConfig.getIdcUrls();
        this.totalUrls = topicConfig.getTotalUrls();
        this.startIdx = RandomUtils.nextInt((int)0, (int)this.totalUrls.size());
    }

    @Override
    public void tryPushRequest() {
        if (this.simpleMessage == null) {
            return;
        }
        List<String> selectedPushUrls = this.getUrl();
        for (String selectedPushUrl : selectedPushUrls) {
            this.lastPushTime = System.currentTimeMillis();
            HttpPost builder = new HttpPost(selectedPushUrl);
            String requestCode = String.valueOf(RequestCode.HTTP_PUSH_CLIENT_ASYNC.getRequestCode());
            builder.addHeader("code", requestCode);
            builder.addHeader("language", "JAVA");
            builder.addHeader("version", ProtocolVersion.V1.getVersion());
            builder.addHeader("eventmeshcluster", this.eventMeshGrpcConfiguration.getEventMeshCluster());
            builder.addHeader("eventmeship", this.eventMeshGrpcConfiguration.eventMeshIp);
            builder.addHeader("eventmeshenv", this.eventMeshGrpcConfiguration.getEventMeshEnv());
            builder.addHeader("eventmeshidc", this.eventMeshGrpcConfiguration.getEventMeshIDC());
            RequestHeader requestHeader = this.simpleMessage.getHeader();
            builder.addHeader("protocoltype", requestHeader.getProtocolType());
            builder.addHeader("protocoldesc", requestHeader.getProtocolDesc());
            builder.addHeader("protocolversion", requestHeader.getProtocolVersion());
            builder.addHeader("contenttype", this.simpleMessage.getPropertiesOrDefault("contenttype", "application/cloudevents+json"));
            ArrayList<BasicNameValuePair> body = new ArrayList<BasicNameValuePair>();
            body.add(new BasicNameValuePair("content", this.simpleMessage.getContent()));
            body.add(new BasicNameValuePair("bizseqno", this.simpleMessage.getSeqNum()));
            body.add(new BasicNameValuePair("uniqueId", this.simpleMessage.getUniqueId()));
            body.add(new BasicNameValuePair("randomNo", this.handleMsgContext.getMsgRandomNo()));
            body.add(new BasicNameValuePair("topic", this.simpleMessage.getTopic()));
            body.add(new BasicNameValuePair("extFields", JsonUtils.serialize((Object)this.simpleMessage.getPropertiesMap())));
            this.simpleMessage = SimpleMessage.newBuilder((SimpleMessage)this.simpleMessage).putProperties("reqeventmesh2ctimestamp", String.valueOf(this.lastPushTime)).build();
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(body, StandardCharsets.UTF_8));
            this.addToWaitingMap(this);
            CMD_LOGGER.info("cmd={}|eventMesh2client|from={}|to={}", new Object[]{requestCode, IPUtils.getLocalAddress(), selectedPushUrl});
            try {
                this.eventMeshGrpcServer.getHttpClient().execute((HttpUriRequest)builder, this.handleResponse(selectedPushUrl));
                MESSAGE_LOGGER.info("message|eventMesh2client|url={}|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{selectedPushUrl, this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId()});
            }
            catch (IOException e) {
                long cost = System.currentTimeMillis() - this.lastPushTime;
                MESSAGE_LOGGER.error("message|eventMesh2client|exception={} |emitter|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{e.getMessage(), this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), cost, e});
                this.removeWaitingMap(this);
                this.delayRetry();
            }
        }
    }

    public String toString() {
        return "asyncPushRequest={bizSeqNo=" + this.simpleMessage.getSeqNum() + ",startIdx=" + this.startIdx + ",retryTimes=" + this.retryTimes + ",uniqueId=" + this.simpleMessage.getUniqueId() + ",executeTime=" + DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",lastPushTime=" + DateFormatUtils.format((long)this.lastPushTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + ",createTime=" + DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS") + "}";
    }

    private ResponseHandler<Object> handleResponse(String selectedPushUrl) {
        return response -> {
            this.removeWaitingMap(this);
            long cost = System.currentTimeMillis() - this.lastPushTime;
            if (response.getStatusLine().getStatusCode() != 200) {
                MESSAGE_LOGGER.info("message|eventMesh2client|exception|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{selectedPushUrl, this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), cost});
                this.delayRetry();
            } else {
                String res = "";
                try {
                    res = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Charset.forName("UTF-8"));
                }
                catch (IOException e) {
                    this.complete();
                    return new Object();
                }
                ClientRetCode result = this.processResponseContent(res, selectedPushUrl);
                MESSAGE_LOGGER.info("message|eventMesh2client|{}|url={}|topic={}|bizSeqNo={}|uniqueId={}|cost={}", new Object[]{result, selectedPushUrl, this.simpleMessage.getTopic(), this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), cost});
                if (result == ClientRetCode.OK || result == ClientRetCode.FAIL) {
                    this.complete();
                } else if (result == ClientRetCode.RETRY || result == ClientRetCode.NOLISTEN) {
                    this.delayRetry();
                }
            }
            return new Object();
        };
    }

    private ClientRetCode processResponseContent(String content, String selectedPushUrl) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return ClientRetCode.FAIL;
        }
        try {
            Map ret = (Map)JsonUtils.deserialize((String)content, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Integer retCode = (Integer)ret.get("retCode");
            if (retCode != null && ClientRetCode.contains((Integer)retCode)) {
                return ClientRetCode.get((Integer)retCode);
            }
            return ClientRetCode.FAIL;
        }
        catch (Exception e) {
            MESSAGE_LOGGER.warn("url:{}, bizSeqno:{}, uniqueId:{},  httpResponse:{}", new Object[]{selectedPushUrl, this.simpleMessage.getSeqNum(), this.simpleMessage.getUniqueId(), content});
            return ClientRetCode.FAIL;
        }
    }

    private List<String> getUrl() {
        List localIdcUrl = (List)MapUtils.getObject(this.urls, (Object)this.eventMeshGrpcConfiguration.getEventMeshIDC(), null);
        if (CollectionUtils.isNotEmpty((Collection)localIdcUrl)) {
            if (this.subscriptionMode == Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING) {
                return Collections.singletonList(localIdcUrl.get((this.startIdx + this.retryTimes) % localIdcUrl.size()));
            }
            if (this.subscriptionMode == Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING) {
                return localIdcUrl;
            }
            MESSAGE_LOGGER.error("Invalid Subscription Mode, no message returning back to subscriber.");
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(this.totalUrls)) {
            if (this.subscriptionMode == Subscription.SubscriptionItem.SubscriptionMode.CLUSTERING) {
                return Collections.singletonList(this.totalUrls.get((this.startIdx + this.retryTimes) % this.totalUrls.size()));
            }
            if (this.subscriptionMode == Subscription.SubscriptionItem.SubscriptionMode.BROADCASTING) {
                return this.totalUrls;
            }
            MESSAGE_LOGGER.error("Invalid Subscription Mode, no message returning back to subscriber.");
            return Collections.emptyList();
        }
        MESSAGE_LOGGER.error("No event emitters from subscriber, no message returning.");
        return Collections.EMPTY_LIST;
    }
}

