/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.admin.controller.ClientManageController;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshHttpBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTcpBootstrap;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.connector.ConnectorResource;
import org.apache.eventmesh.runtime.registry.Registry;
import org.apache.eventmesh.runtime.trace.Trace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshServer {
    public static final Logger LOGGER = LoggerFactory.getLogger(EventMeshServer.class);
    private final Acl acl;
    private Registry registry;
    private static Trace trace;
    private final ConnectorResource connectorResource;
    private ServiceState serviceState;
    private final CommonConfiguration configuration;
    private transient ClientManageController clientManageController;
    private static final List<EventMeshBootstrap> BOOTSTRAP_LIST;
    private static final String SERVER_STATE_MSG = "server state:{}";

    public EventMeshServer(ConfigurationWrapper configurationWrapper) throws Exception {
        CommonConfiguration configuration = new CommonConfiguration(configurationWrapper);
        configuration.init();
        this.configuration = configuration;
        this.acl = new Acl();
        this.registry = new Registry();
        trace = new Trace(configuration.isEventMeshServerTraceEnable());
        this.connectorResource = new ConnectorResource();
        List provideServerProtocols = configuration.getEventMeshProvideServerProtocols();
        for (String provideServerProtocol : provideServerProtocols) {
            if ("HTTP".equals(provideServerProtocol)) {
                BOOTSTRAP_LIST.add(new EventMeshHttpBootstrap(this, configurationWrapper, this.registry));
            }
            if ("TCP".equals(provideServerProtocol)) {
                BOOTSTRAP_LIST.add(new EventMeshTcpBootstrap(this, configurationWrapper, this.registry));
            }
            if (!"GRPC".equals(provideServerProtocol)) continue;
            BOOTSTRAP_LIST.add(new EventMeshGrpcBootstrap(configurationWrapper, this.registry));
        }
        this.init();
    }

    private void init() throws Exception {
        if (Objects.nonNull(this.configuration)) {
            this.connectorResource.init(this.configuration.getEventMeshConnectorPluginType());
            if (this.configuration.isEventMeshServerSecurityEnable()) {
                this.acl.init(this.configuration.getEventMeshSecurityPluginType());
            }
            if (this.configuration.isEventMeshServerRegistryEnable()) {
                this.registry.init(this.configuration.getEventMeshRegistryPluginType());
            }
            if (this.configuration.isEventMeshServerTraceEnable()) {
                trace.init(this.configuration.getEventMeshTracePluginType());
            }
        }
        EventMeshTCPServer eventMeshTCPServer = null;
        EventMeshGrpcServer eventMeshGrpcServer = null;
        EventMeshHTTPServer eventMeshHTTPServer = null;
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.init();
            if (eventMeshBootstrap instanceof EventMeshTcpBootstrap) {
                eventMeshTCPServer = ((EventMeshTcpBootstrap)eventMeshBootstrap).getEventMeshTcpServer();
            }
            if (eventMeshBootstrap instanceof EventMeshHttpBootstrap) {
                eventMeshHTTPServer = ((EventMeshHttpBootstrap)eventMeshBootstrap).getEventMeshHttpServer();
            }
            if (!(eventMeshBootstrap instanceof EventMeshGrpcBootstrap)) continue;
            eventMeshGrpcServer = ((EventMeshGrpcBootstrap)eventMeshBootstrap).getEventMeshGrpcServer();
        }
        if (Objects.nonNull(eventMeshTCPServer) && Objects.nonNull(eventMeshHTTPServer) && Objects.nonNull(eventMeshGrpcServer)) {
            this.clientManageController = new ClientManageController(eventMeshTCPServer, eventMeshHTTPServer, eventMeshGrpcServer, this.registry);
            this.clientManageController.setAdminWebHookConfigOperationManage(eventMeshTCPServer.getAdminWebHookConfigOperationManage());
        }
        String eventStore = System.getProperty("eventstore", System.getenv("EVENT_STORE"));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("eventStore : {}", (Object)eventStore);
        }
        this.serviceState = ServiceState.INITED;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(SERVER_STATE_MSG, (Object)this.serviceState);
        }
    }

    public void start() throws Exception {
        if (Objects.nonNull(this.configuration)) {
            if (this.configuration.isEventMeshServerSecurityEnable()) {
                this.acl.start();
            }
            if (this.configuration.isEventMeshServerRegistryEnable()) {
                this.registry.start();
            }
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.start();
        }
        if (Objects.nonNull(this.clientManageController)) {
            this.clientManageController.start();
        }
        this.serviceState = ServiceState.RUNNING;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(SERVER_STATE_MSG, (Object)this.serviceState);
        }
    }

    public void shutdown() throws Exception {
        this.serviceState = ServiceState.STOPING;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(SERVER_STATE_MSG, (Object)this.serviceState);
        }
        for (EventMeshBootstrap eventMeshBootstrap : BOOTSTRAP_LIST) {
            eventMeshBootstrap.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerRegistryEnable()) {
            this.registry.shutdown();
        }
        this.connectorResource.release();
        if (this.configuration != null && this.configuration.isEventMeshServerSecurityEnable()) {
            this.acl.shutdown();
        }
        if (this.configuration != null && this.configuration.isEventMeshServerTraceEnable()) {
            trace.shutdown();
        }
        ConfigurationContextUtil.clear();
        this.serviceState = ServiceState.STOPED;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(SERVER_STATE_MSG, (Object)this.serviceState);
        }
    }

    public static Trace getTrace() {
        return trace;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    static {
        BOOTSTRAP_LIST = new CopyOnWriteArrayList<EventMeshBootstrap>();
    }
}

