/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemotingServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRemotingServer.class);
    private static final int DEFAULT_SLEEP_SECONDS = 30;
    private EventLoopGroup bossGroup;
    private EventLoopGroup ioGroup;
    private EventLoopGroup workerGroup;
    private int port;
    private static final int MAX_THREADS = Runtime.getRuntime().availableProcessors();

    public EventLoopGroup getBossGroup() {
        return this.bossGroup;
    }

    public EventLoopGroup getIoGroup() {
        return this.ioGroup;
    }

    public EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public int getPort() {
        return this.port;
    }

    public void setBossGroup(EventLoopGroup bossGroup) {
        this.bossGroup = bossGroup;
    }

    public void setIoGroup(EventLoopGroup ioGroup) {
        this.ioGroup = ioGroup;
    }

    public void setWorkerGroup(EventLoopGroup workerGroup) {
        this.workerGroup = workerGroup;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private EventLoopGroup initBossGroup(final String threadPrefix) {
        this.bossGroup = new NioEventLoopGroup(1, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadPrefix + "-boss-" + this.count.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        return this.bossGroup;
    }

    private EventLoopGroup initIOGroup(final String threadPrefix, int threadNum) {
        this.ioGroup = new NioEventLoopGroup(threadNum, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadPrefix + "-io-" + this.count.incrementAndGet());
            }
        });
        return this.ioGroup;
    }

    private EventLoopGroup initWorkerGroup(final String threadPrefix, int threadNum) {
        this.workerGroup = new NioEventLoopGroup(threadNum, new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadPrefix + "-worker-" + this.count.incrementAndGet());
            }
        });
        return this.workerGroup;
    }

    public void init(String threadPrefix) throws Exception {
        this.initBossGroup(threadPrefix);
        this.initIOGroup(threadPrefix, MAX_THREADS);
        this.initWorkerGroup(threadPrefix, MAX_THREADS);
    }

    public void shutdown() throws Exception {
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("shutdown bossGroup");
            }
        }
        ThreadUtils.randomSleep((int)30);
        if (this.ioGroup != null) {
            this.ioGroup.shutdownGracefully();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("shutdown ioGroup");
            }
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("shutdown workerGroup");
            }
        }
    }

    public abstract void start() throws Exception;
}

