/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/redirectClientByPath")
public class RedirectClientByPathHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedirectClientByPathHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public RedirectClientByPathHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        try (OutputStream out = httpExchange.getResponseBody();){
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String path = (String)queryStringInfo.get("path");
            String destEventMeshIp = (String)queryStringInfo.get("desteventmeshIp");
            String destEventMeshPort = (String)queryStringInfo.get("desteventmeshport");
            if (StringUtils.isBlank((CharSequence)path) || StringUtils.isBlank((CharSequence)destEventMeshIp) || StringUtils.isBlank((CharSequence)destEventMeshPort) || !StringUtils.isNumeric((CharSequence)destEventMeshPort)) {
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                result = "params illegal!";
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                return;
            }
            logger.info("redirectClientByPath in admin,path:{},destIp:{},destPort:{}====================", new Object[]{path, destEventMeshIp, destEventMeshPort});
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            StringBuilder redirectResult = new StringBuilder();
            try {
                if (!sessionMap.isEmpty()) {
                    for (Session session : sessionMap.values()) {
                        if (!session.getClient().getPath().contains(path)) continue;
                        redirectResult.append("|");
                        redirectResult.append(EventMeshTcp2Client.redirectClient2NewEventMesh(this.eventMeshTCPServer, destEventMeshIp, Integer.parseInt(destEventMeshPort), session, clientSessionGroupMapping));
                    }
                }
            }
            catch (Exception e) {
                logger.error("clientManage|redirectClientByPath|fail|path={}|destEventMeshIp={}|destEventMeshPort={},errMsg={}", new Object[]{path, destEventMeshIp, destEventMeshPort, e});
                result = String.format("redirectClientByPath fail! sessionMap size {%d}, {path=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s}, errorMsg : %s", sessionMap.size(), path, destEventMeshIp, destEventMeshPort, redirectResult, e.getMessage());
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    if (var4_5 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            result = String.format("redirectClientByPath success! sessionMap size {%d}, {path=%s destEventMeshIp=%s destEventMeshPort=%s}, result {%s} ", sessionMap.size(), path, destEventMeshIp, destEventMeshPort, redirectResult);
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            logger.error("redirectClientByPath fail...", (Throwable)e);
        }
    }
}

