/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.metrics.api.model.TcpSummaryMetrics;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.handler.ConfigurationHandler;
import org.apache.eventmesh.runtime.admin.response.Error;
import org.apache.eventmesh.runtime.admin.response.GetMetricsResponse;
import org.apache.eventmesh.runtime.admin.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/metrics")
public class MetricsHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationHandler.class);
    private final HttpSummaryMetrics httpSummaryMetrics;
    private final TcpSummaryMetrics tcpSummaryMetrics;

    public MetricsHandler(EventMeshHTTPServer eventMeshHTTPServer, EventMeshTCPServer eventMeshTcpServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.httpSummaryMetrics = eventMeshHTTPServer.getMetrics().getSummaryMetrics();
        this.tcpSummaryMetrics = eventMeshTcpServer.getEventMeshTcpMonitor().getTcpSummaryMetrics();
    }

    void preflight(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream out = httpExchange.getResponseBody();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void get(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            GetMetricsResponse getMetricsResponse = new GetMetricsResponse(this.httpSummaryMetrics.maxHTTPTPS(), this.httpSummaryMetrics.avgHTTPTPS(), this.httpSummaryMetrics.maxHTTPCost(), this.httpSummaryMetrics.avgHTTPCost(), this.httpSummaryMetrics.avgHTTPBodyDecodeCost(), this.httpSummaryMetrics.getHttpDiscard(), this.httpSummaryMetrics.maxSendBatchMsgTPS(), this.httpSummaryMetrics.avgSendBatchMsgTPS(), this.httpSummaryMetrics.getSendBatchMsgNumSum(), this.httpSummaryMetrics.getSendBatchMsgFailNumSum(), this.httpSummaryMetrics.getSendBatchMsgFailRate(), this.httpSummaryMetrics.getSendBatchMsgDiscardNumSum(), this.httpSummaryMetrics.maxSendMsgTPS(), this.httpSummaryMetrics.avgSendMsgTPS(), this.httpSummaryMetrics.getSendMsgNumSum(), this.httpSummaryMetrics.getSendMsgFailNumSum(), this.httpSummaryMetrics.getSendMsgFailRate(), this.httpSummaryMetrics.getReplyMsgNumSum(), this.httpSummaryMetrics.getReplyMsgFailNumSum(), this.httpSummaryMetrics.maxPushMsgTPS(), this.httpSummaryMetrics.avgPushMsgTPS(), this.httpSummaryMetrics.getHttpPushMsgNumSum(), this.httpSummaryMetrics.getHttpPushFailNumSum(), this.httpSummaryMetrics.getHttpPushMsgFailRate(), this.httpSummaryMetrics.maxHTTPPushLatency(), this.httpSummaryMetrics.avgHTTPPushLatency(), this.httpSummaryMetrics.getBatchMsgQueueSize(), this.httpSummaryMetrics.getSendMsgQueueSize(), this.httpSummaryMetrics.getPushMsgQueueSize(), this.httpSummaryMetrics.getHttpRetryQueueSize(), this.httpSummaryMetrics.avgBatchSendMsgCost(), this.httpSummaryMetrics.avgSendMsgCost(), this.httpSummaryMetrics.avgReplyMsgCost(), this.tcpSummaryMetrics.getRetrySize(), this.tcpSummaryMetrics.getClient2eventMeshTPS(), this.tcpSummaryMetrics.getEventMesh2mqTPS(), this.tcpSummaryMetrics.getMq2eventMeshTPS(), this.tcpSummaryMetrics.getEventMesh2clientTPS(), this.tcpSummaryMetrics.getAllTPS(), this.tcpSummaryMetrics.getAllConnections(), this.tcpSummaryMetrics.getSubTopicNum());
            String result = JsonUtils.toJson(getMetricsResponse);
            httpExchange.sendResponseHeaders(200, result.getBytes().length);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJson(error);
            httpExchange.sendResponseHeaders(500, result.getBytes().length);
            out.write(result.getBytes());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (httpExchange.getRequestMethod().equals("OPTIONS")) {
            this.preflight(httpExchange);
        }
        if (httpExchange.getRequestMethod().equals("GET")) {
            this.get(httpExchange);
        }
    }
}

