/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.loadbalance;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.loadbalance.LoadBalanceSelector;
import org.apache.eventmesh.common.loadbalance.LoadBalanceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomLoadBalanceSelector<T>
implements LoadBalanceSelector<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RandomLoadBalanceSelector.class);
    private final transient List<T> clusterGroup;

    public RandomLoadBalanceSelector(List<T> clusterGroup) {
        this.clusterGroup = clusterGroup;
    }

    @Override
    public T select() {
        if (CollectionUtils.isEmpty(this.clusterGroup)) {
            LOG.warn("No servers available");
            return null;
        }
        return this.clusterGroup.get(ThreadLocalRandom.current().nextInt(this.clusterGroup.size()));
    }

    @Override
    public LoadBalanceType getType() {
        return LoadBalanceType.RANDOM;
    }
}

