/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.thrift;

import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncSpanChunk;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TransactionIdEncoder;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.thrift.dto.TAnnotation;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringValue;
import com.navercorp.pinpoint.thrift.dto.TLocalAsyncId;
import com.navercorp.pinpoint.thrift.dto.TSpan;
import com.navercorp.pinpoint.thrift.dto.TSpanChunk;
import com.navercorp.pinpoint.thrift.dto.TSpanEvent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.thrift.TBase;

public class SpanThriftMessageConverter
implements MessageConverter<SpanType, TBase<?, ?>> {
    private final String agentId;
    private final String applicationName;
    private final long agentStartTime;
    private final short applicationServiceType;
    private final TransactionIdEncoder transactionIdEncoder;
    private final SpanProcessor<TSpan, TSpanChunk> spanPostProcessor;
    private final AnnotationValueThriftMapper annotationMapper = new AnnotationValueThriftMapper();

    public SpanThriftMessageConverter(String applicationName, String agentId, long agentStartTime, short applicationServiceType, TransactionIdEncoder transactionIdEncoder, SpanProcessor<TSpan, TSpanChunk> spanPostProcessor) {
        this.applicationName = Objects.requireNonNull(applicationName, "applicationName");
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
        this.applicationServiceType = applicationServiceType;
        this.transactionIdEncoder = Objects.requireNonNull(transactionIdEncoder, "transactionIdEncoder");
        this.spanPostProcessor = Objects.requireNonNull(spanPostProcessor, "spanPostProcessor");
    }

    @Override
    public TBase<?, ?> toMessage(SpanType message) {
        if (message instanceof SpanChunk) {
            SpanChunk spanChunk = (SpanChunk)message;
            return this.buildTSpanChunk(spanChunk);
        }
        if (message instanceof Span) {
            Span span = (Span)message;
            return this.buildTSpan(span);
        }
        return null;
    }

    @VisibleForTesting
    TSpan buildTSpan(Span span) {
        TSpan tSpan = new TSpan();
        tSpan.setApplicationName(this.applicationName);
        tSpan.setAgentId(this.agentId);
        tSpan.setAgentStartTime(this.agentStartTime);
        tSpan.setApplicationServiceType(this.applicationServiceType);
        TraceRoot traceRoot = span.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        ByteBuffer transactionId = this.transactionIdEncoder.encodeTransactionId(traceId);
        tSpan.setTransactionId(transactionId);
        tSpan.setSpanId(traceId.getSpanId());
        tSpan.setParentSpanId(traceId.getParentSpanId());
        tSpan.setStartTime(span.getStartTime());
        tSpan.setElapsed(span.getElapsedTime());
        tSpan.setServiceType(span.getServiceType());
        tSpan.setRemoteAddr(span.getRemoteAddr());
        Shared shared = traceRoot.getShared();
        tSpan.setRpc(shared.getRpcName());
        tSpan.setEndPoint(shared.getEndPoint());
        tSpan.setFlag(traceId.getFlags());
        tSpan.setErr(shared.getErrorCode());
        tSpan.setParentApplicationName(span.getParentApplicationName());
        tSpan.setParentApplicationType(span.getParentApplicationType());
        tSpan.setAcceptorHost(span.getAcceptorHost());
        tSpan.setApiId(span.getApiId());
        IntStringValue exceptionInfo = span.getExceptionInfo();
        if (exceptionInfo != null) {
            TIntStringValue tIntStringValue = this.buildTIntStringValue(exceptionInfo);
            tSpan.setExceptionInfo(tIntStringValue);
        }
        tSpan.setLoggingTransactionInfo(shared.getLoggingInfo());
        List<Annotation<?>> annotations = span.getAnnotations();
        if (CollectionUtils.hasLength(annotations)) {
            List<TAnnotation> tAnnotations = this.buildTAnnotation(annotations);
            tSpan.setAnnotations(tAnnotations);
        }
        this.spanPostProcessor.preProcess(span, tSpan);
        List<SpanEvent> spanEventList = span.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            List<TSpanEvent> tSpanEvents = this.buildTSpanEventList(spanEventList);
            tSpan.setSpanEventList(tSpanEvents);
        }
        this.spanPostProcessor.postProcess(span, tSpan);
        return tSpan;
    }

    private List<TSpanEvent> buildTSpanEventList(List<SpanEvent> spanEventList) {
        int eventSize = spanEventList.size();
        ArrayList<TSpanEvent> tSpanEventList = new ArrayList<TSpanEvent>(eventSize);
        for (SpanEvent spanEvent : spanEventList) {
            TSpanEvent tSpanEvent = this.buildTSpanEvent(spanEvent);
            tSpanEventList.add(tSpanEvent);
        }
        return tSpanEventList;
    }

    @VisibleForTesting
    TSpanChunk buildTSpanChunk(SpanChunk spanChunk) {
        TSpanChunk tSpanChunk = new TSpanChunk();
        tSpanChunk.setApplicationName(this.applicationName);
        tSpanChunk.setAgentId(this.agentId);
        tSpanChunk.setAgentStartTime(this.agentStartTime);
        tSpanChunk.setApplicationServiceType(this.applicationServiceType);
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        TraceId traceId = traceRoot.getTraceId();
        ByteBuffer transactionId = this.transactionIdEncoder.encodeTransactionId(traceId);
        tSpanChunk.setTransactionId(transactionId);
        tSpanChunk.setSpanId(traceId.getSpanId());
        Shared shared = traceRoot.getShared();
        tSpanChunk.setEndPoint(shared.getEndPoint());
        if (spanChunk instanceof AsyncSpanChunk) {
            AsyncSpanChunk asyncSpanChunk = (AsyncSpanChunk)spanChunk;
            LocalAsyncId localAsyncId = asyncSpanChunk.getLocalAsyncId();
            TLocalAsyncId tLocalAsyncId = new TLocalAsyncId(localAsyncId.getAsyncId(), localAsyncId.getSequence());
            tSpanChunk.setLocalAsyncId(tLocalAsyncId);
        }
        this.spanPostProcessor.preProcess(spanChunk, tSpanChunk);
        List<SpanEvent> spanEventList = spanChunk.getSpanEventList();
        if (CollectionUtils.hasLength(spanEventList)) {
            List<TSpanEvent> tSpanEvents = this.buildTSpanEventList(spanEventList);
            tSpanChunk.setSpanEventList(tSpanEvents);
        }
        this.spanPostProcessor.postProcess(spanChunk, tSpanChunk);
        return tSpanChunk;
    }

    @VisibleForTesting
    TSpanEvent buildTSpanEvent(SpanEvent spanEvent) {
        List<Annotation<?>> annotations;
        AsyncId asyncIdObject;
        TSpanEvent tSpanEvent = new TSpanEvent();
        if (spanEvent.getElapsedTime() != 0) {
            tSpanEvent.setEndElapsed(spanEvent.getElapsedTime());
        }
        tSpanEvent.setSequence((short)spanEvent.getSequence());
        tSpanEvent.setServiceType(spanEvent.getServiceType());
        tSpanEvent.setEndPoint(spanEvent.getEndPoint());
        if (spanEvent.getDepth() != -1) {
            tSpanEvent.setDepth(spanEvent.getDepth());
        }
        if (spanEvent.getNextSpanId() != -1L) {
            tSpanEvent.setNextSpanId(spanEvent.getNextSpanId());
        }
        tSpanEvent.setDestinationId(spanEvent.getDestinationId());
        tSpanEvent.setApiId(spanEvent.getApiId());
        IntStringValue exceptionInfo = spanEvent.getExceptionInfo();
        if (exceptionInfo != null) {
            TIntStringValue tIntStringValue = this.buildTIntStringValue(exceptionInfo);
            tSpanEvent.setExceptionInfo(tIntStringValue);
        }
        if ((asyncIdObject = spanEvent.getAsyncIdObject()) != null) {
            tSpanEvent.setNextAsyncId(asyncIdObject.getAsyncId());
        }
        if (CollectionUtils.hasLength(annotations = spanEvent.getAnnotations())) {
            List<TAnnotation> tAnnotations = this.buildTAnnotation(annotations);
            tSpanEvent.setAnnotations(tAnnotations);
        }
        return tSpanEvent;
    }

    private TIntStringValue buildTIntStringValue(IntStringValue exceptionInfo) {
        TIntStringValue tIntStringValue = new TIntStringValue(exceptionInfo.getIntValue());
        String stringValue = exceptionInfo.getStringValue();
        if (stringValue != null) {
            tIntStringValue.setStringValue(stringValue);
        }
        return tIntStringValue;
    }

    @VisibleForTesting
    List<TAnnotation> buildTAnnotation(List<? extends Annotation<?>> annotations) {
        ArrayList<TAnnotation> tAnnotationList = new ArrayList<TAnnotation>(annotations.size());
        for (Annotation<?> annotation : annotations) {
            TAnnotation tAnnotation = new TAnnotation(annotation.getKey());
            TAnnotationValue tAnnotationValue = this.annotationMapper.buildTAnnotationValue(annotation);
            if (tAnnotationValue != null) {
                tAnnotation.setValue(tAnnotationValue);
            }
            tAnnotationList.add(tAnnotation);
        }
        return tAnnotationList;
    }

    public String toString() {
        return "SpanThriftMessageConverter{agentId='" + this.agentId + '\'' + ", applicationName='" + this.applicationName + '\'' + ", agentStartTime=" + this.agentStartTime + ", applicationServiceType=" + this.applicationServiceType + '}';
    }
}

