/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanChunkFactory;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedStorage
implements Storage {
    private static final Logger logger = LogManager.getLogger(BufferedStorage.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private static final int DEFAULT_BUFFER_SIZE = 20;
    private final int bufferSize;
    private final SpanChunkFactory spanChunkFactory;
    private List<SpanEvent> storage;
    private final DataSender<SpanType> dataSender;

    public BufferedStorage(SpanChunkFactory spanChunkFactory, DataSender<SpanType> dataSender, int bufferSize) {
        this.spanChunkFactory = Objects.requireNonNull(spanChunkFactory, "spanChunkFactory");
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.bufferSize = bufferSize;
        this.storage = this.allocateBuffer();
    }

    @Override
    public void store(SpanEvent spanEvent) {
        List<SpanEvent> storage = this.getBuffer();
        storage.add(spanEvent);
        if (this.overflow(storage)) {
            List<SpanEvent> flushData = this.clearBuffer();
            this.sendSpanChunk(flushData);
        }
    }

    private boolean overflow(List<SpanEvent> storage) {
        return storage.size() >= this.bufferSize;
    }

    private List<SpanEvent> allocateBuffer() {
        return new ArrayList<SpanEvent>(this.bufferSize);
    }

    private List<SpanEvent> getBuffer() {
        List<SpanEvent> copy = this.storage;
        if (copy == null) {
            this.storage = copy = this.allocateBuffer();
        }
        return copy;
    }

    private List<SpanEvent> clearBuffer() {
        List<SpanEvent> copy = this.storage;
        this.storage = null;
        return copy;
    }

    @Override
    public void store(Span span) {
        boolean success;
        List<SpanEvent> spanEventList = this.clearBuffer();
        span.setSpanEventList(spanEventList);
        span.finish();
        if (isDebug) {
            logger.debug("Flush {}", (Object)span);
        }
        if (!(success = this.dataSender.send(span))) {
            logger.debug("send fail");
        }
    }

    @Override
    public void flush() {
        List<SpanEvent> spanEventList = this.clearBuffer();
        if (CollectionUtils.hasLength(spanEventList)) {
            this.sendSpanChunk(spanEventList);
        }
    }

    private void sendSpanChunk(List<SpanEvent> spanEventList) {
        boolean success;
        SpanChunk spanChunk = this.spanChunkFactory.newSpanChunk(spanEventList);
        if (isDebug) {
            logger.debug("Flush {}", (Object)spanChunk);
        }
        if (!(success = this.dataSender.send(spanChunk))) {
            logger.debug("send fail");
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "BufferedStorage{bufferSize=" + this.bufferSize + ", dataSender=" + this.dataSender + '}';
    }
}

