/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.thrift;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.ByteSizeUnit;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.provider.thrift.AbstractClientFactoryProvider;
import com.navercorp.pinpoint.profiler.context.thrift.config.ThriftTransportConfig;
import com.navercorp.pinpoint.profiler.receiver.CommandDispatcher;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.client.ConnectionFactoryProvider;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.packet.HandshakePropertyType;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PinpointClientFactoryProvider
extends AbstractClientFactoryProvider
implements Provider<PinpointClientFactory> {
    private final ThriftTransportConfig thriftTransportConfig;
    private final Provider<AgentInformation> agentInformation;
    private final Provider<ConnectionFactoryProvider> connectionFactoryProvider;
    private final CommandDispatcher commandDispatcher;

    @Inject
    public PinpointClientFactoryProvider(ThriftTransportConfig thriftTransportConfig, Provider<AgentInformation> agentInformation, CommandDispatcher commandDispatcher, Provider<ConnectionFactoryProvider> connectionFactoryProvider) {
        this.thriftTransportConfig = Objects.requireNonNull(thriftTransportConfig, "thriftTransportConfig");
        this.agentInformation = Objects.requireNonNull(agentInformation, "agentInformation");
        this.commandDispatcher = Objects.requireNonNull(commandDispatcher, "commandDispatcher");
        this.connectionFactoryProvider = Objects.requireNonNull(connectionFactoryProvider, "connectionFactoryProvider");
    }

    public PinpointClientFactory get() {
        DefaultPinpointClientFactory pinpointClientFactory = new DefaultPinpointClientFactory((ConnectionFactoryProvider)this.connectionFactoryProvider.get());
        pinpointClientFactory.setWriteTimeoutMillis(this.thriftTransportConfig.getTcpDataSenderPinpointClientWriteTimeout());
        pinpointClientFactory.setRequestTimeoutMillis(this.thriftTransportConfig.getTcpDataSenderPinpointClientRequestTimeout());
        pinpointClientFactory.setReconnectDelay(this.thriftTransportConfig.getTcpDataSenderPinpointClientReconnectInterval());
        pinpointClientFactory.setPingDelay(this.thriftTransportConfig.getTcpDataSenderPinpointClientPingInterval());
        pinpointClientFactory.setEnableWorkerPacketDelay(this.thriftTransportConfig.getTcpDataSenderPinpointClientHandshakeInterval());
        int writeBufferHighWaterMark = this.getByteSize(this.thriftTransportConfig.getTcpDataSenderPinpointClientWriteBufferHighWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(32L));
        int writeBufferLowWaterMark = this.getByteSize(this.thriftTransportConfig.getTcpDataSenderPinpointClientWriteBufferLowWaterMark(), ByteSizeUnit.MEGA_BYTES.toBytesSizeAsInt(16L));
        if (writeBufferLowWaterMark > writeBufferHighWaterMark) {
            this.logger.warn("must be writeBufferHighWaterMark({}) >= writeBufferLowWaterMark({})", (Object)writeBufferHighWaterMark, (Object)writeBufferLowWaterMark);
            writeBufferLowWaterMark = writeBufferHighWaterMark;
        }
        pinpointClientFactory.setWriteBufferHighWaterMark(writeBufferHighWaterMark);
        pinpointClientFactory.setWriteBufferLowWaterMark(writeBufferLowWaterMark);
        AgentInformation agentInformation = (AgentInformation)this.agentInformation.get();
        Map<String, Object> properties = this.toMap(agentInformation);
        boolean isSupportServerMode = this.thriftTransportConfig.isTcpDataSenderCommandAcceptEnable();
        if (isSupportServerMode) {
            pinpointClientFactory.setMessageListener((MessageListener)this.commandDispatcher);
            pinpointClientFactory.setServerStreamChannelMessageHandler((ServerStreamChannelMessageHandler)this.commandDispatcher);
            properties.put(HandshakePropertyType.SUPPORT_SERVER.getName(), true);
            properties.put(HandshakePropertyType.SUPPORT_COMMAND_LIST.getName(), this.commandDispatcher.getRegisteredCommandServiceCodes());
        } else {
            properties.put(HandshakePropertyType.SUPPORT_SERVER.getName(), false);
        }
        pinpointClientFactory.setProperties(properties);
        return pinpointClientFactory;
    }

    private Map<String, Object> toMap(AgentInformation agentInformation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HandshakePropertyType.AGENT_ID.getName(), agentInformation.getAgentId());
        map.put(HandshakePropertyType.APPLICATION_NAME.getName(), agentInformation.getApplicationName());
        map.put(HandshakePropertyType.HOSTNAME.getName(), agentInformation.getMachineName());
        map.put(HandshakePropertyType.IP.getName(), agentInformation.getHostIp());
        map.put(HandshakePropertyType.PID.getName(), agentInformation.getPid());
        map.put(HandshakePropertyType.SERVICE_TYPE.getName(), agentInformation.getServerType().getCode());
        map.put(HandshakePropertyType.START_TIMESTAMP.getName(), agentInformation.getStartTime());
        map.put(HandshakePropertyType.VERSION.getName(), agentInformation.getAgentVersion());
        return map;
    }
}

