/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.metadata;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.config.TransportModule;
import com.navercorp.pinpoint.profiler.context.provider.metadata.SimpleCacheFactory;
import com.navercorp.pinpoint.profiler.metadata.SimpleCache;

public class SimpleCacheFactoryProvider
implements Provider<SimpleCacheFactory> {
    private final SimpleCache.IdTransformer idTransformer;

    @Inject
    public SimpleCacheFactoryProvider(TransportModule transportModule) {
        if (TransportModule.THRIFT == transportModule) {
            this.idTransformer = new SimpleCache.ZigZagTransformer();
        } else if (TransportModule.GRPC == transportModule) {
            this.idTransformer = new SimpleCache.BypassTransformer();
        } else {
            throw new IllegalStateException("unsupported transportModule:" + transportModule);
        }
    }

    public SimpleCacheFactory get() {
        return new SimpleCacheFactory(this.idTransformer);
    }
}

