/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.TransportModule;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContextModule;
import com.navercorp.pinpoint.profiler.context.module.GrpcModule;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.context.module.PluginModule;
import com.navercorp.pinpoint.profiler.context.module.StatsModule;
import com.navercorp.pinpoint.profiler.context.module.ThriftModule;
import com.navercorp.pinpoint.profiler.context.module.ThriftStatsModule;
import com.navercorp.pinpoint.profiler.context.module.config.ConfigModule;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationContextModuleFactory
implements ModuleFactory {
    private final Logger logger = LogManager.getLogger(this.getClass());

    @Override
    public Module newModule(AgentOption agentOption) {
        ConfigModule config = new ConfigModule(agentOption);
        PluginModule pluginModule = new PluginModule();
        ApplicationContextModule applicationContextModule = new ApplicationContextModule();
        Module rpcModule = this.newRpcModule(agentOption);
        StatsModule statsModule = new StatsModule();
        ThriftStatsModule thriftStatsModule = new ThriftStatsModule();
        return Modules.combine((Module[])new Module[]{config, pluginModule, applicationContextModule, rpcModule, statsModule, thriftStatsModule});
    }

    protected Module newRpcModule(AgentOption agentOption) {
        ProfilerConfig profilerConfig = agentOption.getProfilerConfig();
        TransportModule transportModule = profilerConfig.getTransportModule();
        if (TransportModule.GRPC == transportModule) {
            this.logger.info("load GrpcModule");
            return new GrpcModule(profilerConfig);
        }
        if (TransportModule.THRIFT == transportModule) {
            this.logger.info("load ThriftModule");
            return new ThriftModule(profilerConfig);
        }
        this.logger.info("load ThriftModule");
        return new ThriftModule(profilerConfig);
    }
}

