/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicIdGenerator
implements IdGenerator {
    public static final long UNTRACKED_ID = 0L;
    public static final long RESERVED_MAX = 0L;
    public static final long RESERVED_MIN = -1000L;
    public static final long INITIAL_TRANSACTION_ID = 1L;
    public static final long INITIAL_CONTINUED_TRANSACTION_ID = -1001L;
    public static final long INITIAL_DISABLED_ID = -1002L;
    public static final long INITIAL_CONTINUED_DISABLED_ID = -1003L;
    public static final long INITIAL_SKIPPED_ID = -1004L;
    public static final long INITIAL_CONTINUED_SKIPPED_ID = -1005L;
    public static final int DECREMENT_CYCLE = 5;
    public static final int NEGATIVE_DECREMENT_CYCLE = -5;
    private final AtomicLong transactionId = new AtomicLong(1L);
    private final AtomicLong continuedTransactionId = new AtomicLong(-1001L);
    private final AtomicLong disabledId = new AtomicLong(-1002L);
    private final AtomicLong continuedDisabledId = new AtomicLong(-1003L);
    private final AtomicLong skippedId = new AtomicLong(-1004L);
    private final AtomicLong continuedSkippedId = new AtomicLong(-1005L);

    @Inject
    public AtomicIdGenerator() {
    }

    @Override
    public long nextTransactionId() {
        return this.transactionId.getAndIncrement();
    }

    @Override
    public long nextContinuedTransactionId() {
        return this.continuedTransactionId.getAndAdd(-5L);
    }

    @Override
    public long nextDisabledId() {
        return this.disabledId.getAndAdd(-5L);
    }

    @Override
    public long nextContinuedDisabledId() {
        return this.continuedDisabledId.getAndAdd(-5L);
    }

    @Override
    public long nextSkippedId() {
        return this.skippedId.getAndAdd(-5L);
    }

    @Override
    public long nextContinuedSkippedId() {
        return this.continuedSkippedId.getAndAdd(-5L);
    }

    @Override
    public long currentTransactionId() {
        return this.transactionId.get();
    }

    @Override
    public long currentContinuedTransactionId() {
        return this.continuedTransactionId.get();
    }

    @Override
    public long currentDisabledId() {
        return this.disabledId.get();
    }

    @Override
    public long currentContinuedDisabledId() {
        return this.continuedDisabledId.get();
    }

    @Override
    public long currentSkippedId() {
        return this.skippedId.get();
    }

    @Override
    public long currentContinuedSkippedId() {
        return this.continuedSkippedId.get();
    }
}

