/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.scope.DefaultTraceScopePool;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultTrace
implements Trace {
    private static final Logger logger = LogManager.getLogger((String)DefaultTrace.class.getName());
    private static final boolean isDebug = logger.isDebugEnabled();
    private final CallStack<SpanEvent> callStack;
    private final Storage storage;
    private final SpanRecorder spanRecorder;
    private final WrappedSpanEventRecorder wrappedSpanEventRecorder;
    private boolean closed = false;
    private DefaultTraceScopePool scopePool;
    private final Span span;
    private final ActiveTraceHandle activeTraceHandle;

    public DefaultTrace(Span span, CallStack<SpanEvent> callStack, Storage storage, boolean sampling, SpanRecorder spanRecorder, WrappedSpanEventRecorder wrappedSpanEventRecorder, ActiveTraceHandle activeTraceHandle) {
        this.span = Objects.requireNonNull(span, "span");
        this.callStack = Objects.requireNonNull(callStack, "callStack");
        this.storage = Objects.requireNonNull(storage, "storage");
        Assert.isTrue((boolean)sampling, (String)"sampling must be true");
        this.spanRecorder = Objects.requireNonNull(spanRecorder, "spanRecorder");
        this.wrappedSpanEventRecorder = Objects.requireNonNull(wrappedSpanEventRecorder, "wrappedSpanEventRecorder");
        this.activeTraceHandle = Objects.requireNonNull(activeTraceHandle, "activeTraceHandle");
        this.setCurrentThread();
    }

    private void setCurrentThread() {
        long threadId = Thread.currentThread().getId();
        this.getTraceRoot().getShared().setThreadId(threadId);
    }

    private TraceRoot getTraceRoot() {
        return this.span.getTraceRoot();
    }

    private SpanEventRecorder wrappedSpanEventRecorder(WrappedSpanEventRecorder wrappedSpanEventRecorder, SpanEvent spanEvent) {
        wrappedSpanEventRecorder.setWrapped(spanEvent);
        return wrappedSpanEventRecorder;
    }

    public SpanEventRecorder traceBlockBegin() {
        return this.traceBlockBegin(-1);
    }

    public SpanEventRecorder traceBlockBegin(int stackId) {
        SpanEvent spanEvent = this.traceBlockBegin0(stackId);
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent traceBlockBegin0(int stackId) {
        if (this.closed) {
            if (logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            SpanEvent dummy = this.dummySpanEvent();
            return dummy;
        }
        SpanEvent spanEvent = this.newSpanEvent(stackId);
        this.callStack.push(spanEvent);
        return spanEvent;
    }

    private void stackDump(String caused) {
        PinpointException exception = new PinpointException(caused);
        logger.warn("[DefaultTrace] Corrupted call stack found TraceRoot:{}, CallStack:{}", (Object)this.getTraceRoot(), this.callStack, (Object)exception);
    }

    public void traceBlockEnd() {
        this.traceBlockEnd(-1);
    }

    public void traceBlockEnd(int stackId) {
        if (this.closed) {
            if (logger.isWarnEnabled()) {
                this.stackDump("already closed trace");
            }
            return;
        }
        SpanEvent spanEvent = this.callStack.pop();
        if (spanEvent == null) {
            if (logger.isWarnEnabled()) {
                this.stackDump("call stack is empty.");
            }
            return;
        }
        if (this.isDummySpanEvent(spanEvent)) {
            if (isDebug) {
                logger.debug("[{}] Skip dummy spanEvent", (Object)this);
            }
            return;
        }
        if (spanEvent.getStackId() != stackId && logger.isWarnEnabled()) {
            this.stackDump("not matched stack id. expected=" + stackId + ", current=" + spanEvent.getStackId());
        }
        if (spanEvent.isTimeRecording()) {
            spanEvent.markAfterTime();
        }
        this.logSpan(spanEvent);
        SpanEvent previous = this.callStack.peek();
        this.wrappedSpanEventRecorder.setWrapped(previous);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            logger.warn("Already closed {}", (Object)this);
            return;
        }
        this.closed = true;
        long afterTime = System.currentTimeMillis();
        if (!this.callStack.empty()) {
            if (logger.isWarnEnabled()) {
                this.stackDump("not empty call stack");
            }
        } else {
            if (this.span.isTimeRecording()) {
                this.span.markAfterTime(afterTime);
            }
            this.logSpan(this.span);
        }
        this.storage.close();
        this.purgeActiveTrace(afterTime);
    }

    private void purgeActiveTrace(long currentTime) {
        ActiveTraceHandle copy = this.activeTraceHandle;
        if (copy != null) {
            copy.purge(currentTime);
        }
    }

    void flush() {
        this.storage.flush();
        this.closed = true;
    }

    public TraceId getTraceId() {
        return this.getTraceRoot().getTraceId();
    }

    public long getId() {
        return this.getTraceRoot().getLocalTransactionId();
    }

    public long getStartTime() {
        return this.getTraceRoot().getTraceStartTime();
    }

    public boolean canSampled() {
        return true;
    }

    public boolean isRoot() {
        return this.getTraceId().isRoot();
    }

    private void logSpan(SpanEvent spanEvent) {
        this.storage.store(spanEvent);
    }

    private void logSpan(Span span) {
        this.storage.store(span);
    }

    public boolean isAsync() {
        return false;
    }

    public boolean isRootStack() {
        return this.callStack.empty();
    }

    public SpanRecorder getSpanRecorder() {
        return this.spanRecorder;
    }

    public SpanEventRecorder currentSpanEventRecorder() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            if (logger.isWarnEnabled()) {
                this.stackDump("call stack is empty");
            }
            spanEvent = this.dummySpanEvent();
        }
        return this.wrappedSpanEventRecorder(this.wrappedSpanEventRecorder, spanEvent);
    }

    private SpanEvent newSpanEvent(int stackId) {
        SpanEvent spanEvent = this.callStack.newInstance();
        spanEvent.markStartTime();
        spanEvent.setStackId(stackId);
        return spanEvent;
    }

    @VisibleForTesting
    SpanEvent dummySpanEvent() {
        return this.callStack.getFactory().disableInstance();
    }

    @VisibleForTesting
    boolean isDummySpanEvent(SpanEvent spanEvent) {
        return this.callStack.getFactory().isDisable(spanEvent);
    }

    public int getCallStackFrameId() {
        SpanEvent spanEvent = this.callStack.peek();
        if (spanEvent == null) {
            return 0;
        }
        return spanEvent.getStackId();
    }

    public TraceScope getScope(String name) {
        if (this.scopePool == null) {
            return null;
        }
        return this.scopePool.get(name);
    }

    public TraceScope addScope(String name) {
        if (this.scopePool == null) {
            this.scopePool = new DefaultTraceScopePool();
        }
        return this.scopePool.add(name);
    }

    public String toString() {
        return "DefaultTrace{, traceRoot=" + this.getTraceRoot() + '}';
    }
}

