/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.scope.TraceScope;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncTraceContext;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAsyncContext
implements AsyncContext {
    private static final Logger logger = LogManager.getLogger(DefaultAsyncContext.class);
    private final TraceRoot traceRoot;
    private final AsyncId asyncId;
    private final boolean canSampled;
    private final AsyncTraceContext asyncTraceContext;
    private final int asyncMethodApiId;

    public DefaultAsyncContext(AsyncTraceContext asyncTraceContext, TraceRoot traceRoot, AsyncId asyncId, int asyncMethodApiId, boolean canSampled) {
        this.asyncTraceContext = Objects.requireNonNull(asyncTraceContext, "asyncTraceContext");
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncId = Objects.requireNonNull(asyncId, "asyncId");
        this.asyncMethodApiId = asyncMethodApiId;
        this.canSampled = canSampled;
    }

    public TraceRoot getTraceRoot() {
        return this.traceRoot;
    }

    public Trace continueAsyncTraceObject() {
        Reference<Trace> reference = this.asyncTraceContext.currentRawTraceObject();
        Trace nestedTrace = reference.get();
        if (nestedTrace != null) {
            if (nestedTrace.canSampled()) {
                return nestedTrace;
            }
            return null;
        }
        return this.newAsyncContextTrace(reference);
    }

    private Trace newAsyncContextTrace(Reference<Trace> reference) {
        SpanEventRecorder recorder;
        TraceScope oldScope;
        LocalAsyncId localAsyncId = this.asyncId.nextLocalAsyncId();
        Trace asyncTrace = this.asyncTraceContext.newAsyncContextTraceObject(this.traceRoot, localAsyncId, this.canSampled);
        this.bind(reference, asyncTrace);
        if (logger.isDebugEnabled()) {
            logger.debug("asyncTraceContext.continueAsyncTraceObject() AsyncTrace:{}", (Object)asyncTrace);
        }
        if ((oldScope = asyncTrace.addScope("##ASYNC_TRACE_SCOPE")) != null) {
            if (logger.isWarnEnabled()) {
                logger.warn("Duplicated async trace scope={}.", (Object)oldScope.getName());
            }
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("start async trace scope");
        }
        if ((recorder = asyncTrace.currentSpanEventRecorder()) != null) {
            recorder.recordServiceType(ServiceType.ASYNC);
            recorder.recordApiId(this.asyncMethodApiId);
        }
        if (asyncTrace.canSampled()) {
            return asyncTrace;
        }
        return null;
    }

    private void bind(Reference<Trace> reference, Trace asyncTrace) {
        Assert.state((reference.get() == null ? 1 : 0) != 0, (String)"traceReference is  null");
        reference.set(asyncTrace);
    }

    public Trace currentAsyncTraceObject() {
        Reference<Trace> reference = this.asyncTraceContext.currentTraceObject();
        return reference.get();
    }

    public void close() {
        this.asyncTraceContext.removeTraceObject();
    }

    public String toString() {
        return "DefaultAsyncContext{traceRoot=" + this.traceRoot + ", asyncId=" + this.asyncId + '}';
    }
}

