/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.webhook.receive.storage;

import com.alibaba.nacos.api.config.ConfigFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.apache.eventmesh.webhook.api.utils.StringUtils;
import org.apache.eventmesh.webhook.receive.storage.WebhookFileListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HookConfigOperationManage
implements WebHookConfigOperation {
    private static final String FILE_OPERATION_MODE = "file";
    private static final String WEBHOOK_FILEMODE_FILEPATH_PROP = "eventMesh.webHook.fileMode.filePath";
    private static final String NACOS_OPERATION_MODE = "nacos";
    private static final String WEBHOOK_NACOSMODE = "eventMesh.webHook.nacosMode";
    private final Map<String, WebHookConfig> cacheWebHookConfig = new ConcurrentHashMap<String, WebHookConfig>();
    public Logger logger = LoggerFactory.getLogger(this.getClass());
    private String operationMode;
    private ConfigService nacosConfigService;

    public HookConfigOperationManage() {
    }

    public HookConfigOperationManage(ConfigurationWrapper configurationWrapper) throws FileNotFoundException, NacosException {
        this.operationMode = configurationWrapper.getProp("eventMesh.webHook.operationMode");
        if (FILE_OPERATION_MODE.equals(this.operationMode)) {
            new WebhookFileListener(configurationWrapper.getProp(WEBHOOK_FILEMODE_FILEPATH_PROP), this.cacheWebHookConfig);
        } else if (NACOS_OPERATION_MODE.equals(this.operationMode)) {
            this.nacosModeInit(configurationWrapper.getPropertiesByConfig(WEBHOOK_NACOSMODE, true));
        }
    }

    private void nacosModeInit(Properties config) throws NacosException {
        this.nacosConfigService = ConfigFactory.createConfigService((Properties)config);
    }

    public WebHookConfig queryWebHookConfigById(WebHookConfig webHookConfig) {
        if (FILE_OPERATION_MODE.equals(this.operationMode)) {
            return this.cacheWebHookConfig.get(StringUtils.getFileName((String)webHookConfig.getCallbackPath()));
        }
        if (NACOS_OPERATION_MODE.equals(this.operationMode)) {
            try {
                String content = this.nacosConfigService.getConfig(webHookConfig.getManufacturerEventName() + ".json", "webhook_" + webHookConfig.getManufacturerName(), 3000L);
                return (WebHookConfig)JsonUtils.deserialize((String)content, WebHookConfig.class);
            }
            catch (NacosException e) {
                this.logger.error("queryWebHookConfigById failed", (Throwable)e);
            }
        }
        return null;
    }

    public List<WebHookConfig> queryWebHookConfigByManufacturer(WebHookConfig webHookConfig, Integer pageNum, Integer pageSize) {
        return null;
    }

    public Integer insertWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.put(webHookConfig.getCallbackPath(), webHookConfig);
        return 1;
    }

    public Integer updateWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.put(webHookConfig.getCallbackPath(), webHookConfig);
        return 1;
    }

    public Integer deleteWebHookConfig(WebHookConfig webHookConfig) {
        this.cacheWebHookConfig.remove(webHookConfig.getCallbackPath());
        return 1;
    }
}

