/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.pinpoint.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.exception.JsonException;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;

public final class PinpointConfiguration {
    private static final String CONFIG_FILE = "pinpoint.properties";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private static final Properties properties = new Properties();
    private static String agentId;
    private static String agentName;
    private static String applicationName;
    private static GrpcTransportConfig grpcTransportConfig;

    public static String getAgentId() {
        return agentId;
    }

    public static String getAgentName() {
        return agentName;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static GrpcTransportConfig getGrpcTransportConfig() {
        return grpcTransportConfig;
    }

    private static void initializeConfig() {
        applicationName = properties.getProperty("eventmesh.trace.pinpoint.applicationName");
        if (StringUtils.isBlank((CharSequence)applicationName)) {
            applicationName = Optional.ofNullable(System.getProperty("applicationName")).orElseGet(() -> System.getenv("applicationName"));
        }
        Objects.requireNonNull(applicationName, String.format("%s can not be null", "eventmesh.trace.pinpoint.applicationName"));
        agentName = properties.getProperty("eventmesh.trace.pinpoint.agentName");
        if (StringUtils.isBlank((CharSequence)agentName)) {
            agentName = applicationName;
        }
        if (StringUtils.isBlank((CharSequence)(agentId = properties.getProperty("eventmesh.trace.pinpoint.agentId")))) {
            agentId = StringUtils.substring((String)agentName, (int)0, (int)15) + "-" + RandomStringUtils.generateNum((int)8);
        }
        Properties temporary = PropertiesUtils.getPropertiesByPrefix((Properties)properties, (String)"eventmesh.trace.pinpoint");
        grpcTransportConfig = PinpointConfiguration.convertValue(temporary, GrpcTransportConfig.class);
    }

    private static void loadProperties() {
        URL resource = PinpointConfiguration.class.getClassLoader().getResource(CONFIG_FILE);
        if (resource != null) {
            try (InputStream inputStream = resource.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                if (inputStream.available() > 0) {
                    properties.load(reader);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Load %s file from classpath error", CONFIG_FILE));
            }
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONFIG_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Can not load %s file from conf", CONFIG_FILE));
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("convertValue fromValue to toValueType instance error", (Throwable)e);
        }
    }

    static {
        PinpointConfiguration.loadProperties();
        PinpointConfiguration.initializeConfig();
    }
}

