/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.exception.JsonException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String serialize(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("serialize to json error", e);
        }
    }

    public static <T> byte[] serialize(String topic, Class<T> data) throws JsonProcessingException {
        if (Objects.isNull(data)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(data);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("serialize to json error", e);
        }
    }

    public static <T> T deserialize(String json, Class<T> clz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(json, clz);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    public static <T> T deserialize(Class<T> clazz, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new JsonException(String.format("deserialize bytes to %s error", clazz), e);
        }
    }

    public static <T> T deserialize(String str, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(str, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to typeReference error", e);
        }
    }

    public static JsonNode getJsonNode(String json) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readTree(json);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to JsonNode error", e);
        }
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

