/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final String CONF_FILE = "rabbitmq-client.properties";
    private static final Properties PROPERTIES = new Properties();

    public static String getProperty(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : PROPERTIES.getProperty(key, null);
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/rabbitmq-client.properties");){
            if (resourceAsStream != null) {
                PROPERTIES.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            log.error("load file from classpath exception:", (Throwable)e);
            throw new RuntimeException(String.format("Load %s file from classpath error", CONF_FILE));
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + CONF_FILE;
            PropertiesUtils.loadPropertiesWhenFileExist((Properties)PROPERTIES, (String)configPath, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("load file from conf exception:", (Throwable)e);
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", CONF_FILE));
        }
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

