/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rabbitmq.cloudevent;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.eventmesh.connector.rabbitmq.exception.RabbitmqaConnectorException;
import org.apache.eventmesh.connector.rabbitmq.utils.ByteArrayUtils;

public class RabbitmqCloudEvent
implements Serializable {
    private SpecVersion version;
    private String data;
    private Map<String, String> extensions = new HashMap<String, String>();

    public CloudEvent convertToCloudEvent() {
        CloudEventBuilder builder;
        switch (this.version) {
            case V03: {
                builder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                break;
            }
            case V1: {
                builder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                break;
            }
            default: {
                throw new RabbitmqaConnectorException(String.format("CloudEvent version %s does not support.", this.version));
            }
        }
        builder.withData(this.data.getBytes(StandardCharsets.UTF_8)).withId(this.extensions.remove("id")).withSource(URI.create(this.extensions.remove("source"))).withType(this.extensions.remove("type")).withDataContentType(this.extensions.remove("datacontenttype")).withSubject(this.extensions.remove("subject"));
        this.extensions.forEach((arg_0, arg_1) -> ((io.cloudevents.core.builder.CloudEventBuilder)builder).withExtension(arg_0, arg_1));
        return builder.build();
    }

    public static byte[] toByteArray(RabbitmqCloudEvent rabbitmqCloudEvent) throws Exception {
        Optional<byte[]> optionalBytes = ByteArrayUtils.objectToBytes(rabbitmqCloudEvent);
        return optionalBytes.orElseGet(() -> new byte[0]);
    }

    public static RabbitmqCloudEvent getFromByteArray(byte[] body) throws Exception {
        Optional<Object> optionalCloudEvent = ByteArrayUtils.bytesToObject(body);
        return optionalCloudEvent.orElse(null);
    }

    public SpecVersion getVersion() {
        return this.version;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public void setVersion(SpecVersion version) {
        this.version = version;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RabbitmqCloudEvent)) {
            return false;
        }
        RabbitmqCloudEvent other = (RabbitmqCloudEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SpecVersion this$version = this.getVersion();
        SpecVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, String> this$extensions = this.getExtensions();
        Map<String, String> other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RabbitmqCloudEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpecVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, String> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    public String toString() {
        return "RabbitmqCloudEvent(version=" + this.getVersion() + ", data=" + this.getData() + ", extensions=" + this.getExtensions() + ")";
    }
}

