/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PravegaConnectorConfigWrapper {
    private static final Logger log = LoggerFactory.getLogger(PravegaConnectorConfigWrapper.class);
    public static final String PRAVEGA_CONF_FILE = "pravega-connector.properties";
    private static final Properties properties = new Properties();

    public static String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    private static void loadProperties() {
        String path = File.separator + PRAVEGA_CONF_FILE;
        try (InputStream resourceAsStream = PravegaConnectorConfigWrapper.class.getResourceAsStream(path);){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            log.error("Load {}.properties file from classpath error", (Object)path);
            throw new RuntimeException(String.format("Load %s.properties file from classpath error", PRAVEGA_CONF_FILE));
        }
        String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + PRAVEGA_CONF_FILE;
        try {
            if (new File(configPath).exists()) {
                PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath);
            }
        }
        catch (IOException e) {
            log.error("Cannot load {} file from conf", (Object)configPath);
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", PRAVEGA_CONF_FILE));
        }
    }

    private PravegaConnectorConfigWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PravegaConnectorConfigWrapper.loadProperties();
    }
}

