/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega.config;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.pravega.config.PravegaConnectorConfigWrapper;

public class PravegaConnectorConfig {
    public static final String EVENTMESH_PRAVEGA_CONTROLLER_URI = "eventMesh.server.pravega.controller.uri";
    public static final String EVENTMESH_PRAVEGA_SCOPE = "eventMesh.server.pravega.scope";
    public static final String EVENTMESH_PRAVEGA_AUTH_ENABLED = "eventMesh.server.pravega.authEnabled";
    public static final String EVENTMESH_PRAVEGA_USERNAME = "eventMesh.server.pravega.username";
    public static final String EVENTMESH_PRAVEGA_PASSWORD = "eventMesh.server.pravega.password";
    public static final String EVENTMESH_PRAVEGA_TLS_ENABLED = "eventMesh.server.pravega.tlsEnabled";
    public static final String EVENTMESH_PRAVEGA_TRUSTSTORE = "eventMesh.server.pravega.truststore";
    public static final String EVENTMESH_PRAVEGA_CLIENTPOOL_SIZE = "eventMesh.server.pravega.clientPool.size";
    public static final String EVENTMESH_PRAVEGA_QUEUE_SIZE = "eventMesh.server.pravega.queue.size";
    private URI controllerURI = URI.create("tcp://127.0.0.1:9090");
    private String scope = "eventmesh-pravega";
    private int clientPoolSize = 8;
    private int queueSize = 512;
    private boolean authEnabled = false;
    private String username = "";
    private String password = "";
    private boolean tlsEnable = false;
    private String truststore = "";
    private static PravegaConnectorConfig INSTANCE = null;

    private PravegaConnectorConfig() {
    }

    public static synchronized PravegaConnectorConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PravegaConnectorConfig();
            INSTANCE.init();
        }
        return INSTANCE;
    }

    private void init() {
        String queueSizeStr;
        String clientPoolSizeStr;
        String truststoreStr;
        String tlsEnableStr;
        String passwordStr;
        String usernameStr;
        String authEnableStr;
        String scopeStr;
        String controllerURIStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_CONTROLLER_URI);
        if (StringUtils.isNotBlank((CharSequence)controllerURIStr)) {
            this.controllerURI = URI.create(StringUtils.trim((String)controllerURIStr));
        }
        if (StringUtils.isNotBlank((CharSequence)(scopeStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_SCOPE)))) {
            this.scope = StringUtils.trim((String)scopeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(authEnableStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_AUTH_ENABLED)))) {
            this.authEnabled = Boolean.parseBoolean(StringUtils.trim((String)authEnableStr));
        }
        if (StringUtils.isNotBlank((CharSequence)(usernameStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_USERNAME)))) {
            this.username = StringUtils.trim((String)usernameStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(passwordStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_PASSWORD)))) {
            this.password = StringUtils.trim((String)passwordStr);
        }
        if (StringUtils.isNotBlank((CharSequence)(tlsEnableStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_TLS_ENABLED)))) {
            this.tlsEnable = Boolean.parseBoolean(StringUtils.trim((String)tlsEnableStr));
        }
        if (StringUtils.isNotBlank((CharSequence)(truststoreStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_TRUSTSTORE)))) {
            this.truststore = StringUtils.trim((String)truststoreStr);
        }
        if (StringUtils.isNumeric((CharSequence)(clientPoolSizeStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_CLIENTPOOL_SIZE)))) {
            this.clientPoolSize = Integer.parseInt(clientPoolSizeStr);
        }
        if (StringUtils.isNumeric((CharSequence)(queueSizeStr = PravegaConnectorConfigWrapper.getProp(EVENTMESH_PRAVEGA_QUEUE_SIZE)))) {
            this.queueSize = Integer.parseInt(queueSizeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)this.username) && StringUtils.isNotBlank((CharSequence)this.password)) {
            this.authEnabled = true;
        }
    }

    public URI getControllerURI() {
        return this.controllerURI;
    }

    public String getScope() {
        return this.scope;
    }

    public int getClientPoolSize() {
        return this.clientPoolSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTlsEnable() {
        return this.tlsEnable;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setControllerURI(URI controllerURI) {
        this.controllerURI = controllerURI;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setClientPoolSize(int clientPoolSize) {
        this.clientPoolSize = clientPoolSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTlsEnable(boolean tlsEnable) {
        this.tlsEnable = tlsEnable;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }
}

