/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.pravega;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.connector.pravega.client.PravegaClient;
import org.apache.eventmesh.connector.pravega.exception.PravegaConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PravegaConsumerImpl
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(PravegaConsumerImpl.class);
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private boolean isBroadcast;
    private String instanceName;
    private String consumerGroup;
    private PravegaClient client;
    private EventListener eventListener;

    public void init(Properties keyValue) throws Exception {
        this.isBroadcast = Boolean.parseBoolean(keyValue.getProperty("isBroadcast", "false"));
        this.instanceName = keyValue.getProperty("instanceName", "");
        this.consumerGroup = keyValue.getProperty("consumerGroup", "");
        this.client = PravegaClient.getInstance();
    }

    public void start() {
        started.compareAndSet(false, true);
    }

    public void shutdown() {
        started.compareAndSet(true, false);
    }

    public boolean isStarted() {
        return started.get();
    }

    public boolean isClosed() {
        return !started.get();
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        throw new UnsupportedOperationException();
    }

    public void subscribe(String topic) throws Exception {
        if (!this.client.subscribe(topic, this.isBroadcast, this.consumerGroup, this.instanceName, this.eventListener)) {
            throw new PravegaConnectorException(String.format("subscribe topic[%s] fail.", topic));
        }
    }

    public void unsubscribe(String topic) {
        if (!this.client.unsubscribe(topic, this.isBroadcast, this.consumerGroup)) {
            throw new PravegaConnectorException(String.format("unsubscribe topic[%s] fail.", topic));
        }
    }

    public void registerEventListener(EventListener listener) {
        this.eventListener = listener;
    }
}

