/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.broker;

import io.cloudevents.CloudEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.eventmesh.connector.standalone.broker.MessageQueue;
import org.apache.eventmesh.connector.standalone.broker.model.MessageEntity;
import org.apache.eventmesh.connector.standalone.broker.model.TopicMetadata;
import org.apache.eventmesh.connector.standalone.broker.task.HistoryMessageClearTask;

public class StandaloneBroker {
    private final ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer = new ConcurrentHashMap();
    private final ConcurrentHashMap<TopicMetadata, AtomicLong> offsetMap = new ConcurrentHashMap();

    private StandaloneBroker() {
        this.startHistoryMessageCleanTask();
    }

    public ConcurrentHashMap<TopicMetadata, MessageQueue> getMessageContainer() {
        return this.messageContainer;
    }

    public ConcurrentHashMap<TopicMetadata, AtomicLong> getOffsetMap() {
        return this.offsetMap;
    }

    public static StandaloneBroker getInstance() {
        return StandaloneBrokerInstanceHolder.instance;
    }

    public MessageEntity putMessage(String topicName, CloudEvent message) throws InterruptedException {
        Pair<MessageQueue, AtomicLong> pair = this.createTopicIfAbsent(topicName);
        AtomicLong topicOffset = (AtomicLong)pair.getRight();
        MessageQueue messageQueue = (MessageQueue)pair.getLeft();
        MessageEntity messageEntity = new MessageEntity(new TopicMetadata(topicName), message, topicOffset.getAndIncrement(), System.currentTimeMillis());
        messageQueue.put(messageEntity);
        return messageEntity;
    }

    public CloudEvent takeMessage(String topicName) throws InterruptedException {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        return this.messageContainer.computeIfAbsent(topicMetadata, k -> new MessageQueue()).take().getMessage();
    }

    public CloudEvent getMessage(String topicName) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        MessageEntity head = this.messageContainer.computeIfAbsent(topicMetadata, k -> new MessageQueue()).getHead();
        if (head == null) {
            return null;
        }
        return head.getMessage();
    }

    public CloudEvent getMessage(String topicName, long offset) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        MessageEntity messageEntity = this.messageContainer.computeIfAbsent(topicMetadata, k -> new MessageQueue()).getByOffset(offset);
        if (messageEntity == null) {
            return null;
        }
        return messageEntity.getMessage();
    }

    private void startHistoryMessageCleanTask() {
        Thread thread = new Thread(new HistoryMessageClearTask(this.messageContainer));
        thread.setDaemon(true);
        thread.setName("StandaloneBroker-HistoryMessageCleanTask");
        thread.start();
    }

    public boolean checkTopicExist(String topicName) {
        return this.messageContainer.containsKey(new TopicMetadata(topicName));
    }

    public Pair<MessageQueue, AtomicLong> createTopicIfAbsent(String topicName) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        MessageQueue messageQueue = this.messageContainer.computeIfAbsent(topicMetadata, k -> new MessageQueue());
        AtomicLong offset = this.offsetMap.computeIfAbsent(topicMetadata, k -> new AtomicLong());
        return Pair.of((Object)messageQueue, (Object)offset);
    }

    public void deleteTopicIfExist(String topicName) {
        TopicMetadata topicMetadata = new TopicMetadata(topicName);
        this.messageContainer.remove(topicMetadata);
    }

    public void updateOffset(TopicMetadata topicMetadata, long offset) {
        this.offsetMap.computeIfPresent(topicMetadata, (k, v) -> {
            v.set(offset);
            return v;
        });
    }

    private static class StandaloneBrokerInstanceHolder {
        private static final StandaloneBroker instance = new StandaloneBroker();

        private StandaloneBrokerInstanceHolder() {
        }
    }
}

