/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.standalone.admin;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.admin.Admin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.connector.standalone.broker.MessageQueue;
import org.apache.eventmesh.connector.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.connector.standalone.broker.model.TopicMetadata;

public class StandaloneAdmin
implements Admin {
    private final AtomicBoolean isStarted;
    private final StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();

    public StandaloneAdmin(Properties properties) {
        this.isStarted = new AtomicBoolean(false);
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
    }

    public void init(Properties keyValue) throws Exception {
    }

    public List<TopicProperties> getTopic() throws Exception {
        ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer = this.standaloneBroker.getMessageContainer();
        ArrayList<TopicProperties> topicList = new ArrayList<TopicProperties>();
        for (TopicMetadata topicMetadata : messageContainer.keySet()) {
            MessageQueue messageQueue = messageContainer.get(topicMetadata);
            topicList.add(new TopicProperties(topicMetadata.getTopicName(), (long)(messageQueue.getPutIndex() - messageQueue.getTakeIndex())));
        }
        topicList.sort(Comparator.comparing(t -> t.name));
        return topicList;
    }

    public void createTopic(String topicName) {
        this.standaloneBroker.createTopicIfAbsent(topicName);
    }

    public void deleteTopic(String topicName) {
        this.standaloneBroker.deleteTopicIfExist(topicName);
    }

    public List<CloudEvent> getEvent(String topicName, int offset, int length) throws Exception {
        long messageOffset;
        CloudEvent event;
        if (!this.standaloneBroker.checkTopicExist(topicName)) {
            throw new Exception("The topic name doesn't exist in the message queue");
        }
        ConcurrentHashMap<TopicMetadata, MessageQueue> messageContainer = this.standaloneBroker.getMessageContainer();
        long topicOffset = messageContainer.get(new TopicMetadata(topicName)).getTakeIndex();
        ArrayList<CloudEvent> messageList = new ArrayList<CloudEvent>();
        for (int index = 0; index < length && (event = this.standaloneBroker.getMessage(topicName, messageOffset = topicOffset + (long)offset + (long)index)) != null; ++index) {
            messageList.add(event);
        }
        return messageList;
    }

    public void publish(CloudEvent cloudEvent) throws Exception {
        this.standaloneBroker.putMessage(cloudEvent.getSubject(), cloudEvent);
    }
}

