/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.protocol.meshmessage.resolver.grpc;

import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.v03.CloudEventBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.protos.BatchMessage;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.protocol.api.exception.ProtocolHandleException;

public class GrpcMessageProtocolResolver {
    public static CloudEvent buildEvent(SimpleMessage message) throws ProtocolHandleException {
        try {
            RequestHeader requestHeader = message.getHeader();
            String protocolType = requestHeader.getProtocolType();
            String protocolDesc = requestHeader.getProtocolDesc();
            String protocolVersion = requestHeader.getProtocolVersion();
            String env = requestHeader.getEnv();
            String idc = requestHeader.getIdc();
            String ip = requestHeader.getIp();
            String pid = requestHeader.getPid();
            String sys = requestHeader.getSys();
            String username = requestHeader.getUsername();
            String passwd = requestHeader.getPassword();
            String language = requestHeader.getLanguage();
            String content = message.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                cloudEventBuilder = cloudEventBuilder.withId(message.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", message.getSeqNum()).withExtension("uniqueid", message.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", message.getTtl());
                for (Map.Entry entry : message.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)message.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", message.getTag());
                }
                event = cloudEventBuilder.build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                CloudEventBuilder cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                cloudEventBuilder = cloudEventBuilder.withId(message.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", message.getSeqNum()).withExtension("uniqueid", message.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", message.getTtl());
                for (Map.Entry entry : message.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)message.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", message.getTag());
                }
                event = cloudEventBuilder.build();
            }
            return event;
        }
        catch (Exception e) {
            throw new ProtocolHandleException(e.getMessage(), e.getCause());
        }
    }

    public static List<CloudEvent> buildBatchEvents(BatchMessage message) {
        LinkedList<CloudEvent> events = new LinkedList<CloudEvent>();
        RequestHeader requestHeader = message.getHeader();
        String protocolType = requestHeader.getProtocolType();
        String protocolDesc = requestHeader.getProtocolDesc();
        String protocolVersion = requestHeader.getProtocolVersion();
        String env = requestHeader.getEnv();
        String idc = requestHeader.getIdc();
        String ip = requestHeader.getIp();
        String pid = requestHeader.getPid();
        String sys = requestHeader.getSys();
        String username = requestHeader.getUsername();
        String passwd = requestHeader.getPassword();
        String language = requestHeader.getLanguage();
        for (BatchMessage.MessageItem item : message.getMessageItemList()) {
            io.cloudevents.core.v1.CloudEventBuilder cloudEventBuilder;
            String content = item.getContent();
            CloudEvent event = null;
            if (StringUtils.equals((CharSequence)SpecVersion.V1.toString(), (CharSequence)protocolVersion)) {
                cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v1();
                cloudEventBuilder = cloudEventBuilder.withId(item.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", item.getSeqNum()).withExtension("uniqueid", item.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", item.getTtl());
                for (Map.Entry entry : item.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", item.getTag());
                }
                event = cloudEventBuilder.build();
            } else if (StringUtils.equals((CharSequence)SpecVersion.V03.toString(), (CharSequence)protocolVersion)) {
                cloudEventBuilder = io.cloudevents.core.builder.CloudEventBuilder.v03();
                cloudEventBuilder = cloudEventBuilder.withId(item.getSeqNum()).withSubject(message.getTopic()).withType("eventmeshmessage").withSource(URI.create("/")).withData(content.getBytes(StandardCharsets.UTF_8)).withExtension("env", env).withExtension("idc", idc).withExtension("ip", ip).withExtension("pid", pid).withExtension("sys", sys).withExtension("username", username).withExtension("passwd", passwd).withExtension("language", language).withExtension("protocoltype", protocolType).withExtension("protocoldesc", protocolDesc).withExtension("protocolversion", protocolVersion).withExtension("seqnum", item.getSeqNum()).withExtension("uniqueid", item.getUniqueId()).withExtension("producergroup", message.getProducerGroup()).withExtension("ttl", item.getTtl());
                for (Map.Entry entry : item.getPropertiesMap().entrySet()) {
                    cloudEventBuilder.withExtension((String)entry.getKey(), (String)entry.getValue());
                }
                if (StringUtils.isNotEmpty((CharSequence)item.getTag())) {
                    cloudEventBuilder = cloudEventBuilder.withExtension("tag", item.getTag());
                }
                event = cloudEventBuilder.build();
            }
            events.add(event);
        }
        return events;
    }

    public static SimpleMessageWrapper buildSimpleMessage(CloudEvent cloudEvent) {
        String env = cloudEvent.getExtension("env") == null ? "env" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "env");
        String idc = cloudEvent.getExtension("idc") == null ? "idc" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "idc");
        String ip = cloudEvent.getExtension("ip") == null ? "ip" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "ip");
        String pid = cloudEvent.getExtension("pid") == null ? "33" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "pid");
        String sys = cloudEvent.getExtension("sys") == null ? "sys" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "sys");
        String userName = cloudEvent.getExtension("username") == null ? "user" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "username");
        String passwd = cloudEvent.getExtension("passwd") == null ? "pass" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "passwd");
        String language = cloudEvent.getExtension("language") == null ? "JAVA" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "language");
        String protocol = cloudEvent.getExtension("protocoltype") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "protocoltype");
        String protocolDesc = cloudEvent.getExtension("protocoldesc") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "protocoldesc");
        String protocolVersion = cloudEvent.getExtension("protocolversion") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "protocolversion");
        String seqNum = cloudEvent.getExtension("seqnum") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "seqnum");
        String uniqueId = cloudEvent.getExtension("uniqueid") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "uniqueid");
        String producerGroup = cloudEvent.getExtension("producergroup") == null ? "" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "producergroup");
        String ttl = cloudEvent.getExtension("ttl") == null ? "4000" : GrpcMessageProtocolResolver.getEventExtension(cloudEvent, "ttl");
        RequestHeader header = RequestHeader.newBuilder().setEnv(env).setIdc(idc).setIp(ip).setPid(pid).setSys(sys).setUsername(userName).setPassword(passwd).setLanguage(language).setProtocolType(protocol).setProtocolDesc(protocolDesc).setProtocolVersion(protocolVersion).build();
        SimpleMessage.Builder messageBuilder = SimpleMessage.newBuilder().setHeader(header).setContent(new String(Objects.requireNonNull(cloudEvent.getData()).toBytes(), StandardCharsets.UTF_8)).setProducerGroup(producerGroup).setSeqNum(seqNum).setUniqueId(uniqueId).setTopic(cloudEvent.getSubject()).setTtl(ttl);
        for (String key : cloudEvent.getExtensionNames()) {
            messageBuilder.putProperties(key, GrpcMessageProtocolResolver.getEventExtension(cloudEvent, key));
        }
        SimpleMessage simpleMessage = messageBuilder.build();
        return new SimpleMessageWrapper(simpleMessage);
    }

    private static String getEventExtension(CloudEvent event, String protocolKey) {
        return Objects.requireNonNull(event.getExtension(protocolKey)).toString();
    }
}

