/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.exception.ConnectorRuntimeException;
import org.apache.eventmesh.api.producer.Producer;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Dsl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProducer
implements Producer {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractProducer.class);
    protected final transient AtomicBoolean started = new AtomicBoolean(false);
    protected final transient Properties properties;
    private transient AsyncHttpClient asyncHttpClient;

    AbstractProducer(Properties properties) {
        this.properties = properties;
        this.asyncHttpClient = Dsl.asyncHttpClient();
    }

    ConnectorRuntimeException checkProducerException(CloudEvent cloudEvent, Throwable e) {
        if (cloudEvent.getData() == null) {
            return new ConnectorRuntimeException(String.format("CloudEvent message data does not exist.", e));
        }
        return new ConnectorRuntimeException(String.format("Unknown connector runtime exception.", e));
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public AsyncHttpClient getAsyncHttpClient() {
        return this.asyncHttpClient;
    }
}

