/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.knative.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationWrapper {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationWrapper.class);
    private static final Properties properties = new Properties();

    public static String getProp(String key) {
        return StringUtils.isEmpty((CharSequence)key) ? null : properties.getProperty(key, null);
    }

    private static void loadProperties() {
        try (InputStream resourceAsStream = ConfigurationWrapper.class.getResourceAsStream("/knative-client.properties");){
            if (resourceAsStream != null) {
                properties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Load %s.properties file from classpath error", "knative-client.properties"), e);
        }
        try {
            String configPath = Constants.EVENTMESH_CONF_HOME + File.separator + "knative-client.properties";
            if (new File(configPath).exists()) {
                PropertiesUtils.loadPropertiesWhenFileExist((Properties)properties, (String)configPath, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Cannot load %s file from conf", "knative-client.properties"), e);
        }
    }

    private ConfigurationWrapper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ConfigurationWrapper.loadProperties();
    }
}

