/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import io.netty.channel.Channel;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IPUtils.class);

    public static String getLocalAddress() {
        String dockerHostIp = System.getenv("docker_host_ip");
        if (dockerHostIp != null && !"".equals(dockerHostIp)) {
            return dockerHostIp;
        }
        String priority = System.getProperty("networkInterface.priority", "eth0<eth1<bond1");
        List<String> list = Arrays.asList(priority.split("<"));
        ArrayList<String> preferList = new ArrayList<String>(list);
        NetworkInterface preferNetworkInterface = null;
        try {
            Enumeration<NetworkInterface> enumeration1 = NetworkInterface.getNetworkInterfaces();
            while (enumeration1.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration1.nextElement();
                if (preferNetworkInterface == null) {
                    preferNetworkInterface = networkInterface;
                    continue;
                }
                if (preferList.indexOf(networkInterface.getName()) <= preferList.indexOf(preferNetworkInterface.getName())) continue;
                preferNetworkInterface = networkInterface;
            }
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            if (preferNetworkInterface != null) {
                Enumeration<InetAddress> en = preferNetworkInterface.getInetAddresses();
                IPUtils.getIpResult(ipv4Result, ipv6Result, en);
            } else {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                    IPUtils.getIpResult(ipv4Result, ipv6Result, en);
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (!IPUtils.isValidIPV4Address(ip) || ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                    return ip;
                }
                return ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return IPUtils.normalizeHostAddress(localHost);
        }
        catch (SocketException | UnknownHostException e) {
            LOG.error("socket or unknown host exception:", (Throwable)e);
            return null;
        }
    }

    public static boolean isValidIPV4Address(String ip) {
        String zeroTo255 = "(\\d{1,2}|(0|1)\\d{2}|2[0-4]\\d|25[0-5])";
        String regex = zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255 + "\\." + zeroTo255;
        Pattern p = Pattern.compile(regex);
        if (ip == null) {
            return false;
        }
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    private static void getIpResult(List<String> ipv4Result, List<String> ipv6Result, Enumeration<InetAddress> en) {
        while (en.hasMoreElements()) {
            InetAddress address = en.nextElement();
            if (address.isLoopbackAddress()) continue;
            if (address instanceof Inet6Address) {
                ipv6Result.add(IPUtils.normalizeHostAddress(address));
                continue;
            }
            ipv4Result.add(IPUtils.normalizeHostAddress(address));
        }
    }

    private static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static boolean isValidDomainOrIp(String url, List<IPAddress> ipV4ReservedAddrs, List<IPAddress> ipV6ReservedAddrs) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        if (IPUtils.isValidIp(url)) {
            return true;
        }
        IPAddress ipAddress = IPUtils.domain2Ip(url);
        if (ipAddress == null) {
            return false;
        }
        if (ipAddress.isIPv4()) {
            return !IPUtils.isReservedIp(ipAddress, ipV4ReservedAddrs);
        }
        return !IPUtils.isReservedIp(ipAddress, ipV6ReservedAddrs);
    }

    public static boolean isValidIp(String url) {
        try {
            IPAddressString ipString = new IPAddressString(url);
            if (!ipString.isValid()) {
                return new IPAddressString(new URL(url).getHost()).isValid();
            }
        }
        catch (Exception e) {
            LOG.warn("Invalid URL format url={}", (Object)url, (Object)e);
            return false;
        }
        return true;
    }

    public static IPAddress domain2Ip(String url) {
        HostName hostName = new HostName(url);
        if (hostName.isValid()) {
            return hostName.getAddress();
        }
        try {
            String host = new URL(url).getHost();
            return new HostName(host).getAddress();
        }
        catch (MalformedURLException e) {
            LOG.error("Invalid URL format url={}", (Object)url, (Object)e);
            return null;
        }
    }

    private static boolean isReservedIp(IPAddress ipAddress, List<IPAddress> reservedIps) {
        for (IPAddress address : reservedIps) {
            if (!address.contains(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

