/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.producer;

import io.cloudevents.CloudEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.retry.RetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageContext
extends RetryContext {
    public static final Logger logger = LoggerFactory.getLogger((String)"retry");
    private CloudEvent event;
    private String bizSeqNo;
    private EventMeshProducer eventMeshProducer;
    private long createTime = System.currentTimeMillis();
    private Map<String, String> props;
    public EventMeshHTTPServer eventMeshHTTPServer;
    private List<CloudEvent> eventList;

    public SendMessageContext(String bizSeqNo, CloudEvent event, EventMeshProducer eventMeshProducer, EventMeshHTTPServer eventMeshHTTPServer) {
        this.bizSeqNo = bizSeqNo;
        this.event = event;
        this.eventMeshProducer = eventMeshProducer;
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    public void addProp(String key, String val) {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(key, val);
    }

    public String getProp(String key) {
        return this.props.get(key);
    }

    public String getBizSeqNo() {
        return this.bizSeqNo;
    }

    public void setBizSeqNo(String bizSeqNo) {
        this.bizSeqNo = bizSeqNo;
    }

    public CloudEvent getEvent() {
        return this.event;
    }

    public void setEvent(CloudEvent event) {
        this.event = event;
    }

    public EventMeshProducer getEventMeshProducer() {
        return this.eventMeshProducer;
    }

    public void setEventMeshProducer(EventMeshProducer eventMeshProducer) {
        this.eventMeshProducer = eventMeshProducer;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public List<CloudEvent> getEventList() {
        return this.eventList;
    }

    public void setEventList(List<CloudEvent> eventList) {
        this.eventList = eventList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("sendMessageContext={").append("bizSeqNo=").append(this.bizSeqNo).append(",retryTimes=").append(this.retryTimes).append(",producer=").append(this.eventMeshProducer != null ? this.eventMeshProducer.producerGroupConfig.getGroupName() : null).append(",executeTime=").append(DateFormatUtils.format((long)this.executeTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append(",createTime=").append(DateFormatUtils.format((long)this.createTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    @Override
    public boolean retry() throws Exception {
        if (this.eventMeshProducer == null) {
            return false;
        }
        if (this.retryTimes > 0) {
            return false;
        }
        ++this.retryTimes;
        this.eventMeshProducer.send(this, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                logger.warn("", (Throwable)context.getException());
                SendMessageContext.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendBatchMsgFailed(1L);
            }
        });
        return true;
    }
}

