/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.UnSubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.UnSubscribeResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupConf;
import org.apache.eventmesh.runtime.core.consumergroup.ConsumerGroupTopicConf;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeProcessor
implements HttpRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnSubscribeProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public UnSubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(final ChannelHandlerContext ctx, final AsyncContext<HttpCommand> asyncContext) throws Exception {
        String localAddress = IPUtils.getLocalAddress();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode())), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
        }
        UnSubscribeRequestHeader unSubscribeRequestHeader = (UnSubscribeRequestHeader)asyncContext.getRequest().getHeader();
        UnSubscribeRequestBody unSubscribeRequestBody = (UnSubscribeRequestBody)asyncContext.getRequest().getBody();
        UnSubscribeResponseHeader unSubscribeResponseHeader = UnSubscribeResponseHeader.buildHeader((Integer)Integer.valueOf(asyncContext.getRequest().getRequestCode()), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster(), (String)localAddress, (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv(), (String)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
        if (StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getIdc()) || StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getPid()) || !StringUtils.isNumeric((CharSequence)unSubscribeRequestHeader.getPid()) || StringUtils.isBlank((CharSequence)unSubscribeRequestHeader.getSys())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        if (StringUtils.isBlank((CharSequence)unSubscribeRequestBody.getUrl()) || CollectionUtils.isEmpty((Collection)unSubscribeRequestBody.getTopics()) || StringUtils.isBlank((CharSequence)unSubscribeRequestBody.getConsumerGroup())) {
            HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getRetCode(), (String)EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg()));
            asyncContext.onComplete(responseEventMeshCommand);
            return;
        }
        String pid = unSubscribeRequestHeader.getPid();
        String consumerGroup = unSubscribeRequestBody.getConsumerGroup();
        String unSubscribeUrl = unSubscribeRequestBody.getUrl();
        List unSubTopicList = unSubscribeRequestBody.getTopics();
        CompleteHandler<HttpCommand> handler = new CompleteHandler<HttpCommand>(){

            @Override
            public void onResponse(HttpCommand httpCommand) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("{}", (Object)httpCommand);
                    }
                    UnSubscribeProcessor.this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                    UnSubscribeProcessor.this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - ((HttpCommand)asyncContext.getRequest()).getReqTime());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            HttpCommand err;
            boolean isChange = true;
            this.registerClient(unSubscribeRequestHeader, consumerGroup, unSubTopicList, unSubscribeUrl);
            for (String unSubTopic : unSubTopicList) {
                List<Client> groupTopicClients = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().get(consumerGroup + "@" + unSubTopic);
                Iterator<Client> clientIterator = groupTopicClients.iterator();
                while (clientIterator.hasNext()) {
                    Client client = clientIterator.next();
                    if (!StringUtils.equals((CharSequence)client.getPid(), (CharSequence)pid) || !StringUtils.equals((CharSequence)client.getUrl(), (CharSequence)unSubscribeUrl)) continue;
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("client {} start unsubscribe", (Object)JsonUtils.serialize((Object)client));
                    }
                    clientIterator.remove();
                }
                if (CollectionUtils.isNotEmpty(groupTopicClients)) {
                    HashMap<String, List<String>> idcUrls = new HashMap<String, List<String>>();
                    HashSet<String> clientUrls = new HashSet<String>();
                    for (Client client : groupTopicClients) {
                        if (StringUtils.equals((CharSequence)unSubscribeUrl, (CharSequence)client.getUrl())) continue;
                        clientUrls.add(client.getUrl());
                        ArrayList urls = (ArrayList)idcUrls.get(client.getIdc());
                        if (urls != null) continue;
                        urls = new ArrayList();
                        idcUrls.put(client.getIdc(), urls);
                    }
                    ConcurrentHashMap<String, ConsumerGroupConf> concurrentHashMap2 = this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping();
                    synchronized (concurrentHashMap2) {
                        ConsumerGroupConf consumerGroupConf = this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup);
                        Map<String, ConsumerGroupTopicConf> map = consumerGroupConf.getConsumerGroupTopicConf();
                        for (Map.Entry<String, ConsumerGroupTopicConf> topicConf : map.entrySet()) {
                            if (!StringUtils.equals((CharSequence)unSubTopic, (CharSequence)topicConf.getKey())) continue;
                            ConsumerGroupTopicConf latestTopicConf = new ConsumerGroupTopicConf();
                            latestTopicConf.setConsumerGroup(consumerGroup);
                            latestTopicConf.setTopic(unSubTopic);
                            latestTopicConf.setSubscriptionItem(topicConf.getValue().getSubscriptionItem());
                            latestTopicConf.setUrls(clientUrls);
                            latestTopicConf.setIdcUrls(idcUrls);
                            map.put(unSubTopic, latestTopicConf);
                        }
                        this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().put(consumerGroup, consumerGroupConf);
                        continue;
                    }
                }
                isChange = false;
                break;
            }
            long startTime = System.currentTimeMillis();
            if (isChange) {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().get(consumerGroup));
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                }
                catch (Exception e) {
                    err = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    LOGGER.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            } else {
                try {
                    this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, null);
                    HttpCommand responseEventMeshCommand = asyncContext.getRequest().createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                    asyncContext.onComplete(responseEventMeshCommand, handler);
                    this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().keySet().removeIf(s -> StringUtils.contains((CharSequence)s, (CharSequence)consumerGroup));
                    this.eventMeshHTTPServer.getSubscriptionManager().getLocalConsumerGroupMapping().keySet().removeIf(s -> StringUtils.equals((CharSequence)consumerGroup, (CharSequence)s));
                }
                catch (Exception e) {
                    err = asyncContext.getRequest().createHttpCommandResponse((Header)unSubscribeResponseHeader, (Body)UnSubscribeResponseBody.buildBody((Integer)EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getRetCode(), (String)(EventMeshRetCode.EVENTMESH_UNSUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2))));
                    asyncContext.onComplete(err);
                    long endTime = System.currentTimeMillis();
                    LOGGER.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|url={}", new Object[]{endTime - startTime, JsonUtils.serialize((Object)unSubscribeRequestBody.getTopics()), unSubscribeRequestBody.getUrl(), e});
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgFailed();
                    this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsgCost(endTime - startTime);
                }
            }
        }
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    private void registerClient(UnSubscribeRequestHeader unSubscribeRequestHeader, String consumerGroup, List<String> topicList, String url) {
        for (String topic : topicList) {
            Client client = new Client();
            client.setEnv(unSubscribeRequestHeader.getEnv());
            client.setIdc(unSubscribeRequestHeader.getIdc());
            client.setSys(unSubscribeRequestHeader.getSys());
            client.setIp(unSubscribeRequestHeader.getIp());
            client.setPid(unSubscribeRequestHeader.getPid());
            client.setConsumerGroup(consumerGroup);
            client.setTopic(topic);
            client.setUrl(url);
            client.setLastUpTime(new Date());
            String groupTopicKey = client.getConsumerGroup() + "@" + client.getTopic();
            if (this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().containsKey(groupTopicKey)) {
                List<Client> localClients = this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().get(groupTopicKey);
                boolean isContains = false;
                for (Client localClient : localClients) {
                    if (!StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)client.getUrl())) continue;
                    isContains = true;
                    localClient.setLastUpTime(client.getLastUpTime());
                    break;
                }
                if (isContains) continue;
                localClients.add(client);
                continue;
            }
            ArrayList<Client> clients = new ArrayList<Client>();
            clients.add(client);
            this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().put(groupTopicKey, clients);
        }
    }
}

