/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import io.cloudevents.CloudEvent;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.RandomStringUtils;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.http.producer.SendMessageContext;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshTrace(isEnable=true)
public class SendAsyncRemoteEventProcessor
implements AsyncHttpProcessor {
    private static final Logger log = LoggerFactory.getLogger(SendAsyncRemoteEventProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;

    public SendAsyncRemoteEventProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    @Override
    public void handler(final HandlerService.HandlerSpecific handlerSpecific, HttpRequest httpRequest) throws Exception {
        block18: {
            String content;
            AsyncContext<HttpEventWrapper> asyncContext = handlerSpecific.getAsyncContext();
            ChannelHandlerContext ctx = handlerSpecific.getCtx();
            HttpEventWrapper requestWrapper = asyncContext.getRequest();
            String localAddress = IPUtils.getLocalAddress();
            if (log.isInfoEnabled()) {
                log.info("uri={}|{}|client2eventMesh|from={}|to={}", new Object[]{requestWrapper.getRequestURI(), "http", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), localAddress});
            }
            Map requestHeaderMap = requestWrapper.getHeaderMap();
            String source = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            String env = this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv();
            String meshGroup = env + '-' + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC() + '-' + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster() + '-' + this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getSysID();
            requestHeaderMap.put("ip", source);
            requestHeaderMap.put("env", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv());
            requestHeaderMap.put("idc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
            requestHeaderMap.put("sys", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getSysID());
            requestHeaderMap.put("producergroup", meshGroup);
            requestWrapper.buildSysHeaderForClient();
            requestHeaderMap.putIfAbsent("source", source);
            requestWrapper.buildSysHeaderForCE();
            Map bodyMap = Optional.ofNullable(JsonUtils.deserialize((String)new String(requestWrapper.getBody(), Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<Map<String, Object>>(){})).orElseGet(Maps::newHashMap);
            requestWrapper.setBody(bodyMap.get("content").toString().getBytes(StandardCharsets.UTF_8));
            final String bizNo = requestHeaderMap.getOrDefault("bizseqno", RandomStringUtils.generateNum((int)30)).toString();
            final String uniqueId = requestHeaderMap.getOrDefault("uniqueid", RandomStringUtils.generateNum((int)30)).toString();
            String ttl = ((Object)requestHeaderMap.getOrDefault("ttl", 4000)).toString();
            requestWrapper.getSysHeaderMap().putIfAbsent("bizseqno", bizNo);
            requestWrapper.getSysHeaderMap().putIfAbsent("uniqueid", uniqueId);
            requestWrapper.getSysHeaderMap().putIfAbsent("ttl", ttl);
            final HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
            responseHeaderMap.put("uri", requestWrapper.getRequestURI());
            responseHeaderMap.put("eventmeshcluster", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshCluster());
            responseHeaderMap.put("eventmeship", localAddress);
            responseHeaderMap.put("eventmeshenv", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshEnv());
            responseHeaderMap.put("eventmeshidc", this.eventMeshHTTPServer.getEventMeshHttpConfiguration().getEventMeshIDC());
            final HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
            Map sysHeaderMap = requestWrapper.getSysHeaderMap();
            Iterator it = requestHeaderMap.entrySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next().getKey();
                if (!sysHeaderMap.containsKey(key)) continue;
                it.remove();
            }
            String protocolType = requestHeaderMap.getOrDefault("protocoltype", "http").toString();
            ProtocolAdaptor httpProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
            CloudEvent event = httpProtocolAdaptor.toCloudEvent((ProtocolTransportObject)requestWrapper);
            if (event == null || StringUtils.isBlank((CharSequence)event.getId()) || event.getSource() == null || event.getSpecVersion() == null || StringUtils.isBlank((CharSequence)event.getType()) || StringUtils.isBlank((CharSequence)event.getSubject())) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            String pid = this.getExtension(event, "pid");
            String sys = this.getExtension(event, "sys");
            if (StringUtils.isBlank((CharSequence)this.getExtension(event, "idc")) || StringUtils.isBlank((CharSequence)pid) || !StringUtils.isNumeric((CharSequence)pid) || StringUtils.isBlank((CharSequence)sys)) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            String producerGroup = this.getExtension(event, "producergroup");
            final String topic = event.getSubject();
            if (StringUtils.isBlank((CharSequence)bizNo) || StringUtils.isBlank((CharSequence)uniqueId) || StringUtils.isBlank((CharSequence)producerGroup) || StringUtils.isBlank((CharSequence)topic) || event.getData() == null) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            if (this.eventMeshHTTPServer.getEventMeshHttpConfiguration().isEventMeshServerSecurityEnable()) {
                try {
                    Acl.doAclCheckInHttpSend(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), this.getExtension(event, "username"), this.getExtension(event, "passwd"), this.getExtension(event, "sys"), topic, requestWrapper.getRequestURI());
                }
                catch (Exception e) {
                    handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_ACL_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                    log.error("CLIENT HAS NO PERMISSION,SendAsyncMessageProcessor send failed", (Throwable)e);
                    return;
                }
            }
            if (!this.eventMeshHTTPServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_HTTP_MES_SEND_OVER_LIMIT_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            EventMeshProducer eventMeshProducer = this.eventMeshHTTPServer.getProducerManager().getEventMeshProducer(producerGroup);
            if (!eventMeshProducer.getStarted().get()) {
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_GROUP_PRODUCER_STOPED_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            String string = content = event.getData() == null ? "" : new String(event.getData().toBytes(), StandardCharsets.UTF_8);
            if (content.length() > this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize) {
                if (log.isErrorEnabled()) {
                    log.error("Event size exceeds the limit: {}", (Object)this.eventMeshHTTPServer.getEventMeshHttpConfiguration().eventMeshEventSize);
                }
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_SIZE_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            try {
                event = CloudEventBuilder.from((CloudEvent)event).withExtension("msgtype", "persistent").withExtension("reqc2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
                if (log.isDebugEnabled()) {
                    log.debug("msg2MQMsg suc, bizSeqNo={}, topic={}", (Object)bizNo, (Object)topic);
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("msg2MQMsg err, bizSeqNo={}, topic={}", new Object[]{bizNo, topic, e});
                }
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_PACKAGE_MSG_ERR, responseHeaderMap, responseBodyMap, EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event));
                return;
            }
            final SendMessageContext sendMessageContext = new SendMessageContext(bizNo, event, eventMeshProducer, this.eventMeshHTTPServer);
            this.eventMeshHTTPServer.getMetrics().getSummaryMetrics().recordSendMsg();
            final long startTime = System.currentTimeMillis();
            try {
                event = CloudEventBuilder.from((CloudEvent)sendMessageContext.getEvent()).withExtension("reqeventmesh2mqtimestamp", String.valueOf(System.currentTimeMillis())).build();
                handlerSpecific.getTraceOperation().createClientTraceOperation(EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), event), "upstream-eventmesh-client-span", false);
                eventMeshProducer.send(sendMessageContext, new SendCallback(){

                    public void onSuccess(SendResult sendResult) {
                        responseBodyMap.put("retCode", EventMeshRetCode.SUCCESS.getRetCode());
                        responseBodyMap.put("retMsg", EventMeshRetCode.SUCCESS.getErrMsg() + sendResult.toString());
                        if (log.isInfoEnabled()) {
                            log.info("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId});
                        }
                        handlerSpecific.getTraceOperation().endLatestTrace(sendMessageContext.getEvent());
                        handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                    }

                    public void onException(OnExceptionContext context) {
                        responseBodyMap.put("retCode", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getRetCode());
                        responseBodyMap.put("retMsg", EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR.getErrMsg() + EventMeshUtil.stackTrace((Throwable)context.getException(), 2));
                        SendAsyncRemoteEventProcessor.this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                        handlerSpecific.getTraceOperation().exceptionLatestTrace((Throwable)context.getException(), EventMeshUtil.getCloudEventExtensionMap(SpecVersion.V1.toString(), sendMessageContext.getEvent()));
                        handlerSpecific.sendResponse(responseHeaderMap, responseBodyMap);
                        if (log.isErrorEnabled()) {
                            log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId, context.getException()});
                        }
                    }
                });
            }
            catch (Exception ex) {
                this.eventMeshHTTPServer.getHttpRetryer().pushRetry(sendMessageContext.delay(10000L));
                handlerSpecific.sendErrorResponse(EventMeshRetCode.EVENTMESH_SEND_ASYNC_MSG_ERR, responseHeaderMap, responseBodyMap, null);
                if (!log.isErrorEnabled()) break block18;
                log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{System.currentTimeMillis() - startTime, topic, bizNo, uniqueId, ex});
            }
        }
    }

    private String getExtension(CloudEvent event, String protocolKey) {
        return Optional.ofNullable(event.getExtension(protocolKey)).map(Objects::toString).orElseGet(() -> "");
    }

    @Override
    public String[] paths() {
        return new String[]{RequestURI.PUBLISH_BRIDGE.getRequestURI()};
    }
}

