/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import java.util.Date;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.Response;
import org.apache.eventmesh.common.protocol.grpc.protos.Subscription;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.ConsumerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubscribeProcessor.class);
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient GrpcType grpcType = GrpcType.WEBHOOK;

    public SubscribeProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(Subscription subscription, EventEmitter<Response> emitter) throws Exception {
        Objects.requireNonNull(subscription, "subscription can not be null");
        Objects.requireNonNull(emitter, "emitter can not be null");
        RequestHeader header = subscription.getHeader();
        if (!ServiceUtils.validateHeader(header)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateSubscription(this.grpcType, subscription)) {
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(subscription);
        }
        catch (AclException e) {
            if (log.isWarnEnabled()) {
                log.warn("CLIENT HAS NO PERMISSION to Subscribe. failed", (Throwable)e);
            }
            ServiceUtils.sendRespAndDone(StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        ConsumerManager consumerManager = this.eventMeshGrpcServer.getConsumerManager();
        String consumerGroup = subscription.getConsumerGroup();
        LinkedList<ConsumerGroupClient> newClients = new LinkedList<ConsumerGroupClient>();
        for (Subscription.SubscriptionItem item : subscription.getSubscriptionItemsList()) {
            ConsumerGroupClient newClient = ConsumerGroupClient.builder().env(header.getEnv()).idc(header.getIdc()).sys(header.getSys()).ip(header.getIp()).pid(header.getPid()).consumerGroup(consumerGroup).topic(item.getTopic()).grpcType(this.grpcType).subscriptionMode(item.getMode()).url(subscription.getUrl()).lastUpTime(new Date()).build();
            newClients.add(newClient);
        }
        newClients.forEach(consumerManager::registerClient);
        EventMeshConsumer eventMeshConsumer = consumerManager.getEventMeshConsumer(consumerGroup);
        boolean requireRestart = false;
        for (ConsumerGroupClient newClient : newClients) {
            if (!eventMeshConsumer.registerClient(newClient)) continue;
            requireRestart = true;
        }
        if (requireRestart) {
            if (log.isInfoEnabled()) {
                log.info("ConsumerGroup {} topic info changed, restart EventMesh Consumer", (Object)consumerGroup);
            }
            consumerManager.restartEventMeshConsumer(consumerGroup);
        } else if (log.isWarnEnabled()) {
            log.warn("EventMesh consumer [{}] didn't restart.", (Object)consumerGroup);
        }
        ServiceUtils.sendRespAndDone(StatusCode.SUCCESS, "subscribe success", emitter);
    }

    private void doAclCheck(Subscription subscription) throws AclException {
        RequestHeader header = subscription.getHeader();
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
            for (Subscription.SubscriptionItem item : subscription.getSubscriptionItemsList()) {
                Acl.doAclCheckInHttpReceive(header.getIp(), header.getUsername(), header.getPassword(), header.getSys(), item.getTopic(), RequestCode.SUBSCRIBE.getRequestCode());
            }
        }
    }
}

