/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.processor;

import io.cloudevents.CloudEvent;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.grpc.common.SimpleMessageWrapper;
import org.apache.eventmesh.common.protocol.grpc.common.StatusCode;
import org.apache.eventmesh.common.protocol.grpc.protos.RequestHeader;
import org.apache.eventmesh.common.protocol.grpc.protos.SimpleMessage;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.protocol.api.ProtocolAdaptor;
import org.apache.eventmesh.protocol.api.ProtocolPluginFactory;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.ProducerManager;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.EventEmitter;
import org.apache.eventmesh.runtime.core.protocol.grpc.service.ServiceUtils;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyMessageProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Logger aclLogger = LoggerFactory.getLogger((String)"acl");
    private final EventMeshGrpcServer eventMeshGrpcServer;

    public ReplyMessageProcessor(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public void process(SimpleMessage message, final EventEmitter<SimpleMessage> emitter) throws Exception {
        final RequestHeader requestHeader = message.getHeader();
        if (!ServiceUtils.validateHeader(requestHeader)) {
            ServiceUtils.sendStreamRespAndDone(requestHeader, StatusCode.EVENTMESH_PROTOCOL_HEADER_ERR, emitter);
            return;
        }
        if (!ServiceUtils.validateMessage(message)) {
            ServiceUtils.sendStreamRespAndDone(requestHeader, StatusCode.EVENTMESH_PROTOCOL_BODY_ERR, emitter);
            return;
        }
        try {
            this.doAclCheck(message);
        }
        catch (Exception e) {
            this.aclLogger.warn("CLIENT HAS NO PERMISSION,RequestReplyMessageProcessor reply failed", (Throwable)e);
            ServiceUtils.sendStreamRespAndDone(requestHeader, StatusCode.EVENTMESH_ACL_ERR, e.getMessage(), emitter);
            return;
        }
        if (!this.eventMeshGrpcServer.getMsgRateLimiter().tryAcquire(100L, TimeUnit.MILLISECONDS)) {
            this.logger.error("Send message speed over limit.");
            ServiceUtils.sendStreamRespAndDone(requestHeader, StatusCode.EVENTMESH_SEND_MESSAGE_SPEED_OVER_LIMIT_ERR, emitter);
            return;
        }
        final String seqNum = message.getSeqNum();
        final String uniqueId = message.getUniqueId();
        String producerGroup = message.getProducerGroup();
        String mqCluster = message.getPropertiesOrDefault("cluster", "defaultCluster");
        final String replyTopic = mqCluster + "-" + "rr-reply-topic";
        message = SimpleMessage.newBuilder((SimpleMessage)message).setTopic(replyTopic).build();
        String protocolType = requestHeader.getProtocolType();
        ProtocolAdaptor grpcCommandProtocolAdaptor = ProtocolPluginFactory.getProtocolAdaptor((String)protocolType);
        CloudEvent cloudEvent = grpcCommandProtocolAdaptor.toCloudEvent((ProtocolTransportObject)new SimpleMessageWrapper(message));
        ProducerManager producerManager = this.eventMeshGrpcServer.getProducerManager();
        EventMeshProducer eventMeshProducer = producerManager.getEventMeshProducer(producerGroup);
        SendMessageContext sendMessageContext = new SendMessageContext(message.getSeqNum(), cloudEvent, eventMeshProducer, this.eventMeshGrpcServer);
        this.eventMeshGrpcServer.getMetricsMonitor().recordSendMsgToQueue();
        final long startTime = System.currentTimeMillis();
        eventMeshProducer.reply(sendMessageContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                long endTime = System.currentTimeMillis();
                ReplyMessageProcessor.this.logger.info("message|mq2eventmesh|REPLY|ReplyToServer|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, seqNum, uniqueId});
            }

            public void onException(OnExceptionContext onExceptionContext) {
                ServiceUtils.sendStreamRespAndDone(requestHeader, StatusCode.EVENTMESH_REPLY_MSG_ERR, EventMeshUtil.stackTrace((Throwable)onExceptionContext.getException(), 2), emitter);
                long endTime = System.currentTimeMillis();
                ReplyMessageProcessor.this.logger.error("message|mq2eventmesh|REPLY|ReplyToServer|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, replyTopic, seqNum, uniqueId, onExceptionContext.getException()});
            }
        });
    }

    private void doAclCheck(SimpleMessage message) throws AclException {
        RequestHeader requestHeader = message.getHeader();
        if (this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().isEventMeshServerSecurityEnable()) {
            String remoteAdd = requestHeader.getIp();
            String user = requestHeader.getUsername();
            String pass = requestHeader.getPassword();
            String subsystem = requestHeader.getSys();
            String topic = message.getTopic();
            Acl.doAclCheckInHttpSend(remoteAdd, user, pass, subsystem, topic, RequestCode.REPLY_MESSAGE.getRequestCode());
        }
    }
}

