/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.registry.Registry;

public class EventMeshHttpBootstrap
implements EventMeshBootstrap {
    private final EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    public EventMeshHTTPServer eventMeshHttpServer;
    private final EventMeshServer eventMeshServer;
    private final Registry registry;

    public EventMeshHttpBootstrap(EventMeshServer eventMeshServer, ConfigurationWrapper configurationWrapper, Registry registry) {
        this.eventMeshServer = eventMeshServer;
        this.registry = registry;
        this.eventMeshHttpConfiguration = new EventMeshHTTPConfiguration(configurationWrapper);
        this.eventMeshHttpConfiguration.init();
        ConfigurationContextUtil.putIfAbsent((String)"HTTP", (CommonConfiguration)this.eventMeshHttpConfiguration);
    }

    @Override
    public void init() throws Exception {
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHttpServer = new EventMeshHTTPServer(this.eventMeshServer, this.eventMeshHttpConfiguration);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHttpServer.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.eventMeshHttpConfiguration != null) {
            this.eventMeshHttpServer.shutdown();
        }
    }

    public EventMeshHTTPServer getEventMeshHttpServer() {
        return this.eventMeshHttpServer;
    }

    public void setEventMeshHttpServer(EventMeshHTTPServer eventMeshHttpServer) {
        this.eventMeshHttpServer = eventMeshHttpServer;
    }
}

