/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigurationWrapper;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.registry.Registry;

public class EventMeshGrpcBootstrap
implements EventMeshBootstrap {
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private EventMeshGrpcServer eventMeshGrpcServer;
    private final Registry registry;

    public EventMeshGrpcBootstrap(ConfigurationWrapper configurationWrapper, Registry registry) {
        this.registry = registry;
        this.eventMeshGrpcConfiguration = new EventMeshGrpcConfiguration(configurationWrapper);
        this.eventMeshGrpcConfiguration.init();
        ConfigurationContextUtil.putIfAbsent((String)"GRPC", (CommonConfiguration)this.eventMeshGrpcConfiguration);
    }

    @Override
    public void init() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer = new EventMeshGrpcServer(this.eventMeshGrpcConfiguration, this.registry);
            this.eventMeshGrpcServer.init();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.shutdown();
        }
    }

    public EventMeshGrpcServer getEventMeshGrpcServer() {
        return this.eventMeshGrpcServer;
    }

    public void setEventMeshGrpcServer(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }
}

