/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import com.fasterxml.jackson.core.type.TypeReference;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.body.Body;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.apache.eventmesh.common.utils.AssertUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.AbstractRemotingServer;
import org.apache.eventmesh.runtime.boot.SSLContextFactory;
import org.apache.eventmesh.runtime.common.Pair;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HandlerService;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.EventProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.trace.TraceUtils;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.Utils;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPServer
extends AbstractRemotingServer {
    private static final Logger log = LoggerFactory.getLogger(AbstractHTTPServer.class);
    private HandlerService handlerService;
    private HTTPMetricsServer metrics;
    private static final DefaultHttpDataFactory DEFAULT_HTTP_DATA_FACTORY = new DefaultHttpDataFactory(false);
    private final transient AtomicBoolean started = new AtomicBoolean(false);
    private final transient boolean useTLS;
    private Boolean useTrace = false;
    private final transient EventMeshHTTPConfiguration eventMeshHttpConfiguration;
    private final transient ThreadPoolExecutor asyncContextCompleteHandler = ThreadPoolFactory.createThreadPoolExecutor((int)10, (int)10, (String)"EventMesh-http-asyncContext-");
    private static final int MAX_CONNECTIONS = 20000;
    protected final transient Map<String, Pair<HttpRequestProcessor, ThreadPoolExecutor>> processorTable = new ConcurrentHashMap<String, Pair<HttpRequestProcessor, ThreadPoolExecutor>>(64);
    protected final transient Map<String, Pair<EventProcessor, ThreadPoolExecutor>> eventProcessorTable = new ConcurrentHashMap<String, Pair<EventProcessor, ThreadPoolExecutor>>(64);

    public AbstractHTTPServer(int port, boolean useTLS, EventMeshHTTPConfiguration eventMeshHttpConfiguration) {
        this.setPort(port);
        this.useTLS = useTLS;
        this.eventMeshHttpConfiguration = eventMeshHttpConfiguration;
    }

    public void setUseTrace(Boolean useTrace) {
        this.useTrace = useTrace;
    }

    public Boolean getUseTrace() {
        return this.useTrace;
    }

    public void setHandlerService(HandlerService handlerService) {
        this.handlerService = handlerService;
    }

    public HTTPMetricsServer getMetrics() {
        return this.metrics;
    }

    public void setMetrics(HTTPMetricsServer metrics) {
        this.metrics = metrics;
    }

    public HandlerService getHandlerService() {
        return this.handlerService;
    }

    public void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpHeaders responseHeaders = response.headers();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)String.format("text/plain; charset=%s", "UTF-8"));
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        responseHeaders.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendResponse(ChannelHandlerContext ctx, DefaultFullHttpResponse response) {
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                if (log.isWarnEnabled()) {
                    log.warn("send response to [{}] fail, will close this channel", (Object)RemotingHelper.parseChannelRemoteAddr(f.channel()));
                }
                f.channel().close();
            }
        }));
    }

    @Override
    public void start() throws Exception {
        Runnable r = () -> {
            ServerBootstrap b = new ServerBootstrap();
            try {
                ((ServerBootstrap)b.group(this.getBossGroup(), this.getWorkerGroup()).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpsServerInitializer(this.useTLS ? SSLContextFactory.getSslContext(this.eventMeshHttpConfiguration) : null)).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
                if (log.isInfoEnabled()) {
                    log.info("HTTPServer[port={}] started.", (Object)this.getPort());
                }
                b.bind(this.getPort()).channel().closeFuture().sync();
            }
            catch (Exception e) {
                log.error("HTTPServer start error!", (Throwable)e);
                try {
                    this.shutdown();
                }
                catch (Exception ex) {
                    log.error("HTTPServer shutdown error!", (Throwable)ex);
                }
            }
        };
        Thread t = new Thread(r, "EventMesh-http-server");
        t.setDaemon(true);
        t.start();
        this.started.compareAndSet(false, true);
    }

    @Override
    public void shutdown() throws Exception {
        super.shutdown();
        this.started.compareAndSet(true, false);
    }

    public void registerProcessor(Integer requestCode, HttpRequestProcessor processor, ThreadPoolExecutor executor) {
        AssertUtils.notNull((Object)requestCode, (String)"requestCode can't be null");
        AssertUtils.notNull((Object)processor, (String)"processor can't be null");
        AssertUtils.notNull((Object)executor, (String)"executor can't be null");
        this.processorTable.put(requestCode.toString(), new Pair<HttpRequestProcessor, ThreadPoolExecutor>(processor, executor));
    }

    public void registerProcessor(String requestURI, EventProcessor processor, ThreadPoolExecutor executor) {
        AssertUtils.notNull((Object)requestURI, (String)"requestURI can't be null");
        AssertUtils.notNull((Object)processor, (String)"processor can't be null");
        AssertUtils.notNull((Object)executor, (String)"executor can't be null");
        this.eventProcessorTable.put(requestURI, new Pair<EventProcessor, ThreadPoolExecutor>(processor, executor));
    }

    private HttpResponseStatus validateHttpRequest(HttpRequest httpRequest) {
        if (!this.started.get()) {
            return HttpResponseStatus.SERVICE_UNAVAILABLE;
        }
        if (!httpRequest.decoderResult().isSuccess()) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        if (!HttpMethod.GET.equals((Object)httpRequest.method()) && !HttpMethod.POST.equals((Object)httpRequest.method())) {
            return HttpResponseStatus.METHOD_NOT_ALLOWED;
        }
        if (!ProtocolVersion.contains((String)httpRequest.headers().get("version"))) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        return null;
    }

    private void preProcessHttpRequestHeader(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        long startTime = System.currentTimeMillis();
        HttpHeaders requestHeaders = httpRequest.headers();
        requestHeaders.set("reqc2eventmeshtimestamp", (Object)startTime);
        if (StringUtils.isBlank((CharSequence)requestHeaders.get("version"))) {
            requestHeaders.set("version", (Object)ProtocolVersion.V1.getVersion());
        }
        requestHeaders.set("ip", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()));
        requestHeaders.set("reqsendeventmeship", (Object)this.eventMeshHttpConfiguration.getEventMeshServerIp());
    }

    private Map<String, Object> parseHttpRequestBody(HttpRequest httpRequest) throws IOException {
        long bodyDecodeStart = System.currentTimeMillis();
        HashMap<String, Object> httpRequestBody = new HashMap<String, Object>();
        if (HttpMethod.GET.equals((Object)httpRequest.method())) {
            new QueryStringDecoder(httpRequest.uri()).parameters().forEach((key, value) -> httpRequestBody.put((String)key, value.get(0)));
        } else if (HttpMethod.POST.equals((Object)httpRequest.method())) {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)DEFAULT_HTTP_DATA_FACTORY, httpRequest);
            for (InterfaceHttpData parm : decoder.getBodyHttpDatas()) {
                if (InterfaceHttpData.HttpDataType.Attribute != parm.getHttpDataType()) continue;
                Attribute data = (Attribute)parm;
                httpRequestBody.put(data.getName(), data.getValue());
            }
            decoder.destroy();
        }
        this.metrics.getSummaryMetrics().recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
        return httpRequestBody;
    }

    private HttpEventWrapper parseHttpRequest(HttpRequest httpRequest) throws IOException, MethodNotSupportedException {
        HttpEventWrapper httpEventWrapper = new HttpEventWrapper();
        httpEventWrapper.setHttpMethod(httpRequest.method().name());
        httpEventWrapper.setHttpVersion(httpRequest.protocolVersion().protocolName());
        httpEventWrapper.setRequestURI(httpRequest.uri());
        for (String key2 : httpRequest.headers().names()) {
            httpEventWrapper.getHeaderMap().put(key2, httpRequest.headers().get(key2));
        }
        long bodyDecodeStart = System.currentTimeMillis();
        FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        if (HttpMethod.GET.equals((Object)fullHttpRequest.method())) {
            new QueryStringDecoder(fullHttpRequest.uri()).parameters().forEach((key, value) -> bodyMap.put((String)key, (String)value.get(0)));
        } else if (HttpMethod.POST.equals((Object)fullHttpRequest.method())) {
            if (StringUtils.contains((CharSequence)httpRequest.headers().get("Content-Type"), (CharSequence)ContentType.APPLICATION_JSON.getMimeType())) {
                int length = fullHttpRequest.content().readableBytes();
                if (length > 0) {
                    byte[] body = new byte[length];
                    fullHttpRequest.content().readBytes(body);
                    bodyMap.putAll((Map)Objects.requireNonNull(JsonUtils.deserialize((String)new String(body, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<Map<String, Object>>(){})));
                }
            } else {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)DEFAULT_HTTP_DATA_FACTORY, httpRequest);
                for (InterfaceHttpData parm : decoder.getBodyHttpDatas()) {
                    if (InterfaceHttpData.HttpDataType.Attribute != parm.getHttpDataType()) continue;
                    Attribute data = (Attribute)parm;
                    bodyMap.put(data.getName(), data.getValue());
                }
                decoder.destroy();
            }
        } else {
            throw new MethodNotSupportedException("UnSupported Method " + fullHttpRequest.method());
        }
        httpEventWrapper.setBody(Objects.requireNonNull(JsonUtils.serialize(bodyMap)).getBytes(StandardCharsets.UTF_8));
        this.metrics.getSummaryMetrics().recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
        return httpEventWrapper;
    }

    static {
        DiskAttribute.deleteOnExitTemporaryFile = false;
    }

    private class HttpsServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private final transient SSLContext sslContext;

        public HttpsServerInitializer(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        protected void initChannel(SocketChannel channel) {
            ChannelPipeline pipeline = channel.pipeline();
            if (this.sslContext != null && AbstractHTTPServer.this.useTLS) {
                SSLEngine sslEngine = this.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(false);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
            }
            pipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder(), new HttpResponseEncoder(), new HttpConnectionHandler(), new HttpObjectAggregator(Integer.MAX_VALUE), new HTTPHandler()});
        }
    }

    private class HttpConnectionHandler
    extends ChannelDuplexHandler {
        public final transient AtomicInteger connections = new AtomicInteger(0);

        private HttpConnectionHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (this.connections.incrementAndGet() > 20000) {
                if (log.isWarnEnabled()) {
                    log.warn("client|http|channelActive|remoteAddress={}|msg=too many client({}) connect this eventMesh server", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()), (Object)20000);
                }
                ctx.close();
                return;
            }
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.connections.decrementAndGet();
            super.channelInactive(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                if (log.isInfoEnabled()) {
                    log.info("client|http|userEventTriggered|remoteAddress={}|msg={}", (Object)remoteAddress, (Object)evt.getClass().getName());
                }
                ctx.close();
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    private class HTTPHandler
    extends ChannelInboundHandlerAdapter {
        private HTTPHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRead(ChannelHandlerContext ctx, Object message) {
            block18: {
                HttpRequest httpRequest = (HttpRequest)message;
                if (httpRequest == null) {
                    return;
                }
                if (Objects.nonNull(AbstractHTTPServer.this.handlerService) && AbstractHTTPServer.this.handlerService.isProcessorWrapper(httpRequest)) {
                    AbstractHTTPServer.this.handlerService.handler(ctx, httpRequest, AbstractHTTPServer.this.asyncContextCompleteHandler);
                    return;
                }
                try {
                    Span span = null;
                    AbstractHTTPServer.this.preProcessHttpRequestHeader(ctx, httpRequest);
                    Map<String, Object> headerMap = Utils.parseHttpHeader(httpRequest);
                    HttpResponseStatus errorStatus = AbstractHTTPServer.this.validateHttpRequest(httpRequest);
                    if (errorStatus != null) {
                        AbstractHTTPServer.this.sendError(ctx, errorStatus);
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, errorStatus.reasonPhrase(), null);
                        return;
                    }
                    AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPRequest();
                    boolean useRequestURI = false;
                    for (String processURI : AbstractHTTPServer.this.eventProcessorTable.keySet()) {
                        if (!httpRequest.uri().startsWith(processURI)) continue;
                        useRequestURI = true;
                        break;
                    }
                    if (useRequestURI) {
                        if (AbstractHTTPServer.this.useTrace.booleanValue()) {
                            span.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)(httpRequest.method() == null ? "" : httpRequest.method().name()));
                            span.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)(httpRequest.protocolVersion() == null ? "" : httpRequest.protocolVersion().protocolName()));
                            span.setAttribute(SemanticAttributes.HTTP_URL, (Object)httpRequest.uri());
                        }
                        HttpEventWrapper httpEventWrapper = AbstractHTTPServer.this.parseHttpRequest(httpRequest);
                        AsyncContext<Object> asyncContext = new AsyncContext<Object>(httpEventWrapper, null, AbstractHTTPServer.this.asyncContextCompleteHandler);
                        this.processHttpRequest(ctx, asyncContext);
                        break block18;
                    }
                    HttpCommand requestCommand = new HttpCommand();
                    Map bodyMap = AbstractHTTPServer.this.parseHttpRequestBody(httpRequest);
                    String requestCode = HttpMethod.POST.equals((Object)httpRequest.method()) ? httpRequest.headers().get("code") : MapUtils.getString((Map)bodyMap, (Object)StringUtils.lowerCase((String)"code"), (String)"");
                    requestCommand.setHttpMethod(httpRequest.method().name());
                    requestCommand.setHttpVersion(httpRequest.protocolVersion() == null ? "" : httpRequest.protocolVersion().protocolName());
                    requestCommand.setRequestCode(requestCode);
                    HttpCommand responseCommand = null;
                    if (StringUtils.isBlank((CharSequence)requestCode) || !AbstractHTTPServer.this.processorTable.containsKey(requestCode) || !RequestCode.contains((Integer)Integer.valueOf(requestCode))) {
                        responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID);
                        AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_REQUESTCODE_INVALID.getErrMsg(), null);
                        return;
                    }
                    try {
                        requestCommand.setHeader(Header.buildHeader((String)requestCode, headerMap));
                        requestCommand.setBody(Body.buildBody((String)requestCode, (Map)bodyMap));
                    }
                    catch (Exception e) {
                        responseCommand = requestCommand.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_RUNTIME_ERR);
                        AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                        span = TraceUtils.prepareServerSpan(headerMap, "upstream-eventmesh-server-span", false);
                        TraceUtils.finishSpanWithException(span, headerMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)e);
                        ReferenceCountUtil.release((Object)message);
                        return;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("{}", (Object)requestCommand);
                    }
                    AsyncContext<HttpCommand> asyncContext = new AsyncContext<HttpCommand>(requestCommand, responseCommand, AbstractHTTPServer.this.asyncContextCompleteHandler);
                    this.processEventMeshRequest(ctx, asyncContext);
                }
                catch (Exception ex) {
                    log.error("AbrstractHTTPServer.HTTPHandler.channelRead error", (Throwable)ex);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
            }
        }

        public void processHttpRequest(ChannelHandlerContext ctx, AsyncContext<HttpEventWrapper> asyncContext) {
            HttpEventWrapper requestWrapper = asyncContext.getRequest();
            String requestURI = requestWrapper.getRequestURI();
            String processorKey = "/";
            for (String eventProcessorKey : AbstractHTTPServer.this.eventProcessorTable.keySet()) {
                if (!requestURI.startsWith(eventProcessorKey)) continue;
                processorKey = eventProcessorKey;
                break;
            }
            Pair<EventProcessor, ThreadPoolExecutor> choosed = AbstractHTTPServer.this.eventProcessorTable.get(processorKey);
            try {
                choosed.getObject2().submit(() -> {
                    try {
                        EventProcessor processor = (EventProcessor)choosed.getObject1();
                        if (processor.rejectRequest()) {
                            HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR);
                            asyncContext.onComplete(responseWrapper);
                            if (asyncContext.isComplete()) {
                                if (log.isDebugEnabled()) {
                                    log.debug("{}", asyncContext.getResponse());
                                }
                                AbstractHTTPServer.this.sendResponse(ctx, ((HttpEventWrapper)asyncContext.getResponse()).httpResponse());
                            }
                            return;
                        }
                        processor.processRequest(ctx, asyncContext);
                        if (!asyncContext.isComplete()) {
                            return;
                        }
                        AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                        if (log.isDebugEnabled()) {
                            log.debug("{}", asyncContext.getResponse());
                        }
                        AbstractHTTPServer.this.sendResponse(ctx, ((HttpEventWrapper)asyncContext.getResponse()).httpResponse());
                    }
                    catch (Exception e) {
                        log.error("process error", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                HttpEventWrapper responseWrapper = requestWrapper.createHttpResponse(EventMeshRetCode.OVERLOAD);
                asyncContext.onComplete(responseWrapper);
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPDiscard();
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - requestWrapper.getReqTime());
                try {
                    AbstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                }
                catch (Exception e) {
                    log.error("sendResponse error", (Throwable)e);
                }
            }
        }

        public void processEventMeshRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) {
            HttpCommand request = asyncContext.getRequest();
            Pair<HttpRequestProcessor, ThreadPoolExecutor> choosed = AbstractHTTPServer.this.processorTable.get(request.getRequestCode());
            try {
                choosed.getObject2().submit(() -> {
                    try {
                        HttpRequestProcessor processor = (HttpRequestProcessor)choosed.getObject1();
                        if (processor.rejectRequest()) {
                            HttpCommand responseCommand = request.createHttpCommandResponse(EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR);
                            asyncContext.onComplete(responseCommand);
                            if (asyncContext.isComplete()) {
                                AbstractHTTPServer.this.sendResponse(ctx, responseCommand.httpResponse());
                                if (log.isDebugEnabled()) {
                                    log.debug("{}", asyncContext.getResponse());
                                }
                                Map traceMap = ((HttpCommand)asyncContext.getRequest()).getHeader().toMap();
                                TraceUtils.finishSpanWithException(TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false), traceMap, EventMeshRetCode.EVENTMESH_REJECT_BY_PROCESSOR_ERROR.getErrMsg(), null);
                            }
                            return;
                        }
                        processor.processRequest(ctx, asyncContext);
                        if (!asyncContext.isComplete()) {
                            return;
                        }
                        AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                        if (log.isDebugEnabled()) {
                            log.debug("{}", asyncContext.getResponse());
                        }
                        AbstractHTTPServer.this.sendResponse(ctx, ((HttpCommand)asyncContext.getResponse()).httpResponse());
                    }
                    catch (Exception e) {
                        log.error("process error", (Throwable)e);
                    }
                });
            }
            catch (RejectedExecutionException re) {
                asyncContext.onComplete(request.createHttpCommandResponse(EventMeshRetCode.OVERLOAD));
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPDiscard();
                AbstractHTTPServer.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                try {
                    AbstractHTTPServer.this.sendResponse(ctx, asyncContext.getResponse().httpResponse());
                    Map traceMap = asyncContext.getRequest().getHeader().toMap();
                    TraceUtils.finishSpanWithException(TraceUtils.prepareServerSpan(traceMap, "upstream-eventmesh-server-span", false), traceMap, EventMeshRetCode.EVENTMESH_RUNTIME_ERR.getErrMsg(), (Throwable)re);
                }
                catch (Exception e) {
                    log.error("processEventMeshRequest fail", (Throwable)re);
                }
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            super.channelReadComplete(ctx);
            ctx.flush();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            if (null != cause) {
                log.error("", cause);
            }
            if (null != ctx) {
                ctx.close();
            }
        }

        Map<String, String> extractFromRequest(HttpRequest httpRequest) {
            return new HashMap<String, String>();
        }
    }
}

