/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientGroupWrapper;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/showListenClientByTopic")
public class ShowListenClientByTopicHandler
extends AbstractHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(ShowListenClientByTopicHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowListenClientByTopicHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        StringBuilder result = new StringBuilder();
        try (OutputStream out = httpExchange.getResponseBody();){
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String topic = (String)queryStringInfo.get("topic");
            String newLine = System.getProperty("line.separator");
            this.logger.info("showListeningClientByTopic,topic:{}=================", (Object)topic);
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<String, ClientGroupWrapper> clientGroupMap = clientSessionGroupMapping.getClientGroupMap();
            if (!clientGroupMap.isEmpty()) {
                for (ClientGroupWrapper cgw : clientGroupMap.values()) {
                    Set<Session> listenSessionSet = cgw.getTopic2sessionInGroupMapping().get(topic);
                    if (listenSessionSet == null || listenSessionSet.size() <= 0) continue;
                    result.append(String.format("group:%s", cgw.getGroup())).append(newLine);
                    for (Session session : listenSessionSet) {
                        UserAgent userAgent = session.getClient();
                        result.append(String.format("pid=%s | ip=%s | port=%s | path=%s | version=%s", userAgent.getPid(), userAgent.getHost(), userAgent.getPort(), userAgent.getPath(), userAgent.getVersion())).append(newLine);
                    }
                }
            }
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.toString().getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            this.logger.error("ShowListenClientByTopicHandler fail...", (Throwable)e);
        }
    }
}

