/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/clientManage/rejectAllClient")
public class RejectAllClientHandler
extends AbstractHttpHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RejectAllClientHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RejectAllClientHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        try (OutputStream out = httpExchange.getResponseBody();){
            ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
            ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
            ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("rejectAllClient in admin====================");
                }
                if (!sessionMap.isEmpty()) {
                    for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                        InetSocketAddress addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer, entry.getValue(), clientSessionGroupMapping);
                        if (addr == null) continue;
                        successRemoteAddrs.add(addr);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("clientManage rejectAllClient fail", (Throwable)e);
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                out.write(String.format("rejectAllClient fail! sessionMap size {%d}, had reject {%s}, errorMsg : %s", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs), e.getMessage()).getBytes(Constants.DEFAULT_CHARSET));
                if (out != null) {
                    if (var3_4 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
                return;
            }
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(String.format("rejectAllClient success! sessionMap size {%d}, had reject {%s}", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs)).getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            LOGGER.error("rejectAllClient fail.", (Throwable)e);
        }
    }
}

