/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.DeleteHTTPClientRequest;
import org.apache.eventmesh.runtime.admin.response.Error;
import org.apache.eventmesh.runtime.admin.response.GetClientResponse;
import org.apache.eventmesh.runtime.admin.utils.HttpExchangeUtils;
import org.apache.eventmesh.runtime.admin.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/client/http")
public class HTTPClientHandler
extends AbstractHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(HTTPClientHandler.class);
    private final EventMeshHTTPServer eventMeshHTTPServer;

    public HTTPClientHandler(EventMeshHTTPServer eventMeshHTTPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshHTTPServer = eventMeshHTTPServer;
    }

    void preflight(HttpExchange httpExchange) throws IOException {
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Methods", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Headers", "*");
        httpExchange.getResponseHeaders().add("Access-Control-Max-Age", "86400");
        httpExchange.sendResponseHeaders(200, 0L);
        OutputStream out = httpExchange.getResponseBody();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        try {
            String request = HttpExchangeUtils.streamToString(httpExchange.getRequestBody());
            DeleteHTTPClientRequest deleteHTTPClientRequest = JsonUtils.toObject(request, DeleteHTTPClientRequest.class);
            String url = deleteHTTPClientRequest.url;
            for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
                clientList.removeIf(client -> Objects.equals(client.getUrl(), url));
            }
            httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            httpExchange.sendResponseHeaders(200, 0L);
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJson(error);
            httpExchange.sendResponseHeaders(500, result.getBytes().length);
            out.write(result.getBytes());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void list(HttpExchange httpExchange) throws IOException {
        OutputStream out = httpExchange.getResponseBody();
        httpExchange.getResponseHeaders().add("Content-Type", "application/json");
        httpExchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
        try {
            ArrayList<GetClientResponse> getClientResponseList = new ArrayList<GetClientResponse>();
            for (List<Client> clientList : this.eventMeshHTTPServer.getSubscriptionManager().getLocalClientInfoMapping().values()) {
                for (Client client : clientList) {
                    GetClientResponse getClientResponse = new GetClientResponse(Optional.ofNullable(client.getEnv()).orElseGet(() -> ""), Optional.ofNullable(client.getSys()).orElseGet(() -> ""), Optional.ofNullable(client.getUrl()).orElseGet(() -> ""), "0", Optional.ofNullable(client.getHostname()).orElseGet(() -> ""), 0, Optional.ofNullable(client.getApiVersion()).orElseGet(() -> ""), Optional.ofNullable(client.getIdc()).orElseGet(() -> ""), Optional.ofNullable(client.getConsumerGroup()).orElseGet(() -> ""), "", "HTTP");
                    getClientResponseList.add(getClientResponse);
                }
            }
            getClientResponseList.sort((lhs, rhs) -> {
                if (lhs.host.equals(rhs.host)) {
                    return lhs.host.compareTo(rhs.host);
                }
                return Integer.compare(rhs.port, lhs.port);
            });
            String result = JsonUtils.toJson(getClientResponseList);
            httpExchange.sendResponseHeaders(200, result.getBytes().length);
            out.write(result.getBytes());
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            printWriter.flush();
            String stackTrace = writer.toString();
            Error error = new Error(e.toString(), stackTrace);
            String result = JsonUtils.toJson(error);
            httpExchange.sendResponseHeaders(500, result.getBytes().length);
            out.write(result.getBytes());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.warn("out close failed...", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        if (httpExchange.getRequestMethod().equals("OPTIONS")) {
            this.preflight(httpExchange);
        }
        if (httpExchange.getRequestMethod().equals("GET")) {
            this.list(httpExchange);
        }
        if (httpExchange.getRequestMethod().equals("DELETE")) {
            this.delete(httpExchange);
        }
    }
}

