/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.registry.consul.service;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.RegistryException;
import org.apache.eventmesh.api.registry.RegistryService;
import org.apache.eventmesh.api.registry.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.registry.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulRegistryService
implements RegistryService {
    public static final String IP_PORT_SEPARATOR = ":";
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistryService.class);
    private static final AtomicBoolean INIT_STATUS = new AtomicBoolean(false);
    private static final AtomicBoolean START_STATUS = new AtomicBoolean(false);
    private String consulHost;
    private String consulPort;
    private ConsulClient consulClient;
    private String token;

    public void init() throws RegistryException {
        if (INIT_STATUS.compareAndSet(false, true)) {
            for (String key : ConfigurationContextUtil.KEYS) {
                CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
                if (null == commonConfiguration) continue;
                String namesrvAddr = commonConfiguration.getNamesrvAddr();
                if (StringUtils.isBlank((CharSequence)namesrvAddr)) {
                    throw new RegistryException("namesrvAddr cannot be null");
                }
                String[] addr = namesrvAddr.split(IP_PORT_SEPARATOR);
                if (addr.length != 2) {
                    throw new RegistryException("Illegal namesrvAddr");
                }
                this.consulHost = addr[0];
                this.consulPort = addr[1];
                break;
            }
        }
    }

    public void start() throws RegistryException {
        this.consulClient = new ConsulClient(new ConsulRawClient(this.consulHost, Integer.parseInt(this.consulPort)));
    }

    public void shutdown() throws RegistryException {
        INIT_STATUS.compareAndSet(true, false);
        START_STATUS.compareAndSet(true, false);
        this.consulClient = null;
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws RegistryException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(IP_PORT_SEPARATOR);
            NewService service = new NewService();
            service.setPort(Integer.valueOf(Integer.parseInt(ipPort[1])));
            service.setAddress(ipPort[0]);
            service.setName(eventMeshRegisterInfo.getEventMeshName());
            service.setId(eventMeshRegisterInfo.getEventMeshClusterName() + "-" + eventMeshRegisterInfo.getEventMeshName());
            this.consulClient.agentServiceRegister(service, this.token);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
        logger.info("EventMesh successfully registered to consul");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws RegistryException {
        try {
            this.consulClient.agentServiceDeregister(eventMeshUnRegisterInfo.getEventMeshClusterName() + "-" + eventMeshUnRegisterInfo.getEventMeshName(), this.token);
        }
        catch (Exception e) {
            throw new RegistryException(e.getMessage());
        }
        logger.info("EventMesh successfully unregistered to consul");
        return true;
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws RegistryException {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setPassing(true).setToken(this.token).build();
        List healthServices = (List)this.consulClient.getHealthServices(clusterName, request).getValue();
        ArrayList<EventMeshDataInfo> eventMeshDataInfos = new ArrayList<EventMeshDataInfo>();
        healthServices.forEach(healthService -> {
            HealthService.Service service = healthService.getService();
            String[] split = service.getId().split("-");
            eventMeshDataInfos.add(new EventMeshDataInfo(split[0], split[1], service.getAddress() + IP_PORT_SEPARATOR + service.getPort(), 0L, service.getMeta()));
        });
        return eventMeshDataInfos;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws RegistryException {
        Map agentServices = (Map)this.consulClient.getAgentServices().getValue();
        ArrayList<EventMeshDataInfo> eventMeshDataInfos = new ArrayList<EventMeshDataInfo>();
        agentServices.forEach((k, v) -> {
            String[] split = v.getId().split("-");
            eventMeshDataInfos.add(new EventMeshDataInfo(split[0], split[1], v.getAddress() + IP_PORT_SEPARATOR + v.getPort(), 0L, v.getMeta()));
        });
        return eventMeshDataInfos;
    }

    public Map<String, Map<String, Integer>> findEventMeshClientDistributionData(String clusterName, String group, String purpose) throws RegistryException {
        return Collections.emptyMap();
    }

    public void registerMetadata(Map<String, String> metadataMap) {
    }

    public ConsulClient getConsulClient() {
        return this.consulClient;
    }
}

