/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import org.apache.eventmesh.api.RequestReplyCallback;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.connector.kafka.producer.ProducerImpl;

public class KafkaProducerImpl
implements Producer {
    private ProducerImpl producer;

    public synchronized void init(Properties keyValue) {
        keyValue.put("bootstrap.servers", "localhost:9092");
        this.producer = new ProducerImpl(keyValue);
    }

    public boolean isStarted() {
        return this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer.isClosed();
    }

    public void start() {
        this.producer.start();
    }

    public synchronized void shutdown() {
        this.producer.shutdown();
    }

    public void publish(CloudEvent message, SendCallback sendCallback) throws Exception {
        this.producer.sendAsync(message, sendCallback);
    }

    public void request(CloudEvent message, RequestReplyCallback rrCallback, long timeout) throws Exception {
        this.producer.request(message, rrCallback, timeout);
    }

    public boolean reply(CloudEvent message, SendCallback sendCallback) throws Exception {
        this.producer.reply(message, sendCallback);
        return true;
    }

    public void checkTopicExist(String topic) throws Exception {
        this.producer.checkTopicExist(topic);
    }

    public void setExtFields() {
    }

    public void sendOneway(CloudEvent message) {
        this.producer.sendOneway(message);
    }
}

