/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.consumer;

import io.cloudevents.CloudEvent;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.eventmesh.api.AsyncConsumeContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerRunner
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(KafkaConsumerRunner.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final KafkaConsumer<String, CloudEvent> consumer;
    private ConcurrentHashMap<CloudEvent, Long> cloudEventToOffset;
    private EventListener listener;
    private AtomicInteger offset;

    public KafkaConsumerRunner(KafkaConsumer<String, CloudEvent> kafkaConsumer) {
        this.consumer = kafkaConsumer;
        this.cloudEventToOffset = new ConcurrentHashMap();
    }

    public synchronized void setListener(EventListener listener) {
        this.listener = listener;
    }

    public long getOffset(CloudEvent cloudEvent) {
        return this.cloudEventToOffset.getOrDefault(cloudEvent, 0L);
    }

    @Override
    public void run() {
        if (!this.closed.get()) {
            try {
                ConsumerRecords records = this.consumer.poll(Duration.ofMillis(10000L));
                records.forEach(rec -> {
                    try {
                        CloudEvent cloudEvent = (CloudEvent)rec.value();
                        final String topicName = cloudEvent.getSubject();
                        EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = new EventMeshAsyncConsumeContext((ConsumerRecord)rec){
                            final /* synthetic */ ConsumerRecord val$rec;
                            {
                                this.val$rec = consumerRecord;
                            }

                            public void commit(EventMeshAction action) {
                                switch (action) {
                                    case CommitMessage: {
                                        KafkaConsumerRunner.this.logger.info("message commit, topic: {}, current offset:{}", (Object)topicName, (Object)this.val$rec.offset());
                                        break;
                                    }
                                    case ReconsumeLater: {
                                        break;
                                    }
                                    case ManualAck: {
                                        KafkaConsumerRunner.this.logger.info("message ack, topic: {}, current offset:{}", (Object)topicName, (Object)this.val$rec.offset());
                                        break;
                                    }
                                }
                            }
                        };
                        this.cloudEventToOffset.put(cloudEvent, rec.offset());
                        if (this.listener != null) {
                            this.listener.consume(cloudEvent, (AsyncConsumeContext)eventMeshAsyncConsumeContext);
                        }
                    }
                    catch (Exception e) {
                        this.logger.info("Error parsing cloudevents: {}", (Object)e.getMessage());
                    }
                });
            }
            catch (WakeupException e) {
                if (!this.closed.get()) {
                    throw e;
                }
            }
            finally {
                this.consumer.close();
            }
        }
    }

    public void shutdown() {
        this.closed.set(true);
        this.consumer.wakeup();
    }
}

