/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.config;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.connector.kafka.config.ConfigurationWrapper;

public class ClientConfiguration {
    public String namesrvAddr = "";
    public String clientUserName = "username";
    public String clientPass = "password";
    public Integer consumeThreadMin = 2;
    public Integer consumeThreadMax = 2;
    public Integer consumeQueueSize = 10000;
    public Integer pullBatchSize = 32;
    public Integer ackWindow = 1000;
    public Integer pubWindow = 100;
    public long consumeTimeout = 0L;
    public Integer pollNameServerInterval = 10000;
    public Integer heartbeatBrokerInterval = 30000;
    public Integer rebalanceInterval = 20000;
    public String clusterName = "";
    public String accessKey = "";
    public String secretKey = "";

    public void init() {
        String namesrvAddrStr = ConfigurationWrapper.getProp(ConfKeys.KEYS_EVENTMESH_KAFKA_SERVER_PORT);
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)namesrvAddrStr), (Object)String.format("%s error", ConfKeys.KEYS_EVENTMESH_KAFKA_SERVER_PORT));
        this.namesrvAddr = StringUtils.trim((String)namesrvAddrStr);
    }

    static class ConfKeys {
        public static String KEYS_EVENTMESH_KAFKA_SERVER_PORT = "eventMesh.server.kafka.port";

        ConfKeys() {
        }
    }
}

